/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.NeoServer;
import org.neo4j.server.NeoServerWithEmbeddedWebServer;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.helpers.ServerBuilder;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.security.PermanentlyFailingSecurityRule;
import org.neo4j.server.rest.security.PermanentlyPassingSecurityRule;
import org.neo4j.test.TestData;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class SecurityRulesFunctionalTest
extends ExclusiveServerTestBase {
    private NeoServerWithEmbeddedWebServer server;
    private FunctionalTestHelper functionalTestHelper;
    @Rule
    public TestData<RESTDocsGenerator> gen = TestData.producedThrough(RESTDocsGenerator.PRODUCER);

    @After
    public void stopServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    @Documented(value=" In this example, a (dummy) failing security rule is registered to deny\n access to all URIs to the server by listing the rules class in\n +neo4j-server.properties+:\n \n \n @@config\n \n with the rule source code of:\n \n @@failingRule\n \n With this rule registered, any access to the server will be\n denied. In a production-quality implementation the rule\n will likely lookup credentials/claims in a 3rd party\n directory service (e.g. LDAP) or in a local database of\n authorized users.\n \n")
    @TestData.Title(value="Enforcing Server Authorization Rules")
    public void should401WithBasicChallengeWhenASecurityRuleFails() throws Exception {
        this.server = ServerBuilder.server().withDefaultDatabaseTuning().withSecurityRules(PermanentlyFailingSecurityRule.class.getCanonicalName()).build();
        this.server.start();
        ((RESTDocsGenerator)((Object)this.gen.get())).addSnippet("config", "\n[source]\n----\norg.neo4j.server.rest.security_rules=my.rules.PermanentlyFailingSecurityRule\n----\n");
        ((RESTDocsGenerator)((Object)this.gen.get())).addSourceSnippets(PermanentlyFailingSecurityRule.class, new String[]{"failingRule"});
        this.functionalTestHelper = new FunctionalTestHelper((NeoServer)this.server);
        ((RESTDocsGenerator)((Object)this.gen.get())).setSection("ops");
        JaxRsResponse response = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(401).expectedHeader("WWW-Authenticate").post(this.functionalTestHelper.nodeUri()).response();
        Assert.assertThat((Object)response.getHeaders().getFirst((Object)"WWW-Authenticate"), (Matcher)Matchers.containsString((String)"Basic realm=\"WallyWorld\""));
    }

    @Test
    public void should401WithBasicChallengeIfAnyOneOfTheRulesFails() throws Exception {
        this.server = ServerBuilder.server().withDefaultDatabaseTuning().withSecurityRules(PermanentlyPassingSecurityRule.class.getCanonicalName(), PermanentlyFailingSecurityRule.class.getCanonicalName()).build();
        this.server.start();
        this.functionalTestHelper = new FunctionalTestHelper((NeoServer)this.server);
        JaxRsResponse response = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(401).expectedHeader("WWW-Authenticate").post(this.functionalTestHelper.nodeUri()).response();
        Assert.assertThat((Object)response.getHeaders().getFirst((Object)"WWW-Authenticate"), (Matcher)Matchers.containsString((String)"Basic realm=\"WallyWorld\""));
    }

    @Test
    public void shouldRespondWith201IfAllTheRulesPassWhenCreatingANode() throws Exception {
        this.server = ServerBuilder.server().withDefaultDatabaseTuning().withSecurityRules(PermanentlyPassingSecurityRule.class.getCanonicalName()).build();
        this.server.start();
        this.functionalTestHelper = new FunctionalTestHelper((NeoServer)this.server);
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(201).expectedHeader("Location").post(this.functionalTestHelper.nodeUri()).response();
    }
}

