/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.DatabaseBlockedException;
import org.neo4j.server.rest.domain.GraphDbHelper;

public class WebHelper {
    private final URI baseUri;
    private GraphDbHelper helper;

    public WebHelper(URI baseUri, Database database) {
        this.baseUri = baseUri;
        this.helper = new GraphDbHelper(database);
    }

    public URI createNode() throws DatabaseBlockedException {
        long nodeId = this.helper.createNode();
        try {
            return new URI(this.baseUri.toString() + "/" + nodeId);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URI createNodeWithProperties(Map<String, Object> props) throws DatabaseBlockedException {
        URI nodeUri = this.createNode();
        this.setNodeProperties(nodeUri, props);
        return nodeUri;
    }

    private void setNodeProperties(URI nodeUri, Map<String, Object> props) throws DatabaseBlockedException {
        this.helper.setNodeProperties(this.extractNodeId(nodeUri), props);
    }

    private long extractNodeId(URI nodeUri) {
        String path = nodeUri.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return Long.parseLong(path);
    }
}

