/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.webadmin.AbstractWebadminTest;
import org.neo4j.server.webdriver.ElementReference;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

public class DatabrowserWebIT
extends AbstractWebadminTest {
    @Test
    public void referenceNodeIsDefaultViewTest() {
        wl.goToWebadminStartPage();
        wl.clickOnTab("Data browser");
        wl.getDataBrowserItemHeadline().waitForTextToChangeTo(".+/db/data/node/0");
    }

    @Test
    public void canFindNodeByNodePredicatedIdTest() {
        long nodeId = wl.createNodeInDataBrowser();
        wl.searchForInDataBrowser("node:" + nodeId);
        wl.getDataBrowserItemHeadline().waitForTextToChangeTo(".+/db/data/node/" + nodeId);
    }

    @Test
    public void canFindNodeByIdTest() {
        wl.createNodeInDataBrowser();
        wl.searchForInDataBrowser("0");
        wl.getDataBrowserItemHeadline().waitForTextToChangeTo(".+/db/data/node/0");
    }

    @Test
    public void canCreateNodeTest() {
        wl.goToWebadminStartPage();
        wl.clickOnTab("Data browser");
        wl.clickOnButton("Node");
        wl.getDataBrowserItemHeadline().waitForTextToChangeFrom(".+/db/data/node/0");
        wl.getDataBrowserItemHeadline().waitForTextToChangeTo(".+/db/data/node/[0-9]+");
    }

    @Test
    public void canSetNodePropertyTest() {
        wl.goToWebadminStartPage();
        wl.clickOnTab("Data browser");
        wl.clickOnButton("Add property");
        wl.waitForElementToAppear(By.xpath((String)"//li[1]/ul/li//input[@class='property-key']"));
        wl.writeTo(By.xpath((String)"//li[1]/ul/li//input[@class='property-key']"), "mykey");
        wl.writeTo(By.xpath((String)"//li[1]/ul/li//input[@class='property-value']"), new CharSequence[]{"12", Keys.RETURN});
        wl.getElement(By.xpath((String)"//div[@class='data-save-properties button']")).waitForTextToChangeTo("Saved");
        wl.searchForInDataBrowser(wl.getCurrentDatabrowserItemSubtitle());
        this.propertyShouldHaveValue("mykey", "12");
    }

    @Test
    public void canCreateRelationshipTest() {
        wl.createNodeInDataBrowser();
        wl.clickOnButton("Relationship");
        wl.writeTo(By.xpath((String)"//input[@id='create-relationship-to']"), "0");
        wl.clickOnButton("Create");
        wl.getDataBrowserItemHeadline().waitForTextToChangeTo(".+/db/data/relationship/[0-9]+");
    }

    @Test
    public void canFindRelationshipByIdTest() {
        long relId = wl.createRelationshipInDataBrowser();
        wl.goToWebadminStartPage();
        wl.clickOnTab("Data browser");
        wl.searchForInDataBrowser("rel:" + relId);
        wl.getDataBrowserItemHeadline().waitForTextToChangeTo(".+/db/data/relationship/" + relId);
    }

    @Test
    public void canSetRelationshipPropertiesTest() {
        this.canCreateRelationshipTest();
        wl.clickOnButton("Add property");
        wl.waitForElementToAppear(By.xpath((String)"//li[1]/ul/li//input[@class='property-key']"));
        wl.writeTo(By.xpath((String)"//li[1]/ul/li//input[@class='property-key']"), "mykey");
        wl.writeTo(By.xpath((String)"//li[1]/ul/li//input[@class='property-value']"), new CharSequence[]{"12", Keys.RETURN});
        wl.getElement(By.xpath((String)"//div[@class='data-save-properties button']")).waitForTextToChangeTo("Saved");
        wl.searchForInDataBrowser(wl.getCurrentDatabrowserItemSubtitle());
        this.propertyShouldHaveValue("mykey", "12");
    }

    @Test
    public void canExecuteCypherQueries() {
        wl.searchForInDataBrowser("start n=node(0) return n,ID(n)");
        wl.getElement(By.xpath((String)"id('data-area')/div/div/table/tbody/tr[2]/td[2]")).waitForTextToChangeTo("0");
    }

    @Test
    public void cypherResultHasClickableNodes() {
        wl.searchForInDataBrowser("start n=node(0) return n,ID(n)");
        wl.clickOn(By.xpath((String)"id('data-area')/div/div/table/tbody/tr[2]/td[1]/a"));
        wl.getDataBrowserItemHeadline().waitForTextToChangeTo(".+/db/data/node/0");
    }

    private void propertyShouldHaveValue(String expectedKey, String expectedValue) {
        ElementReference el = wl.getElement(By.xpath((String)("//input[@value='" + expectedKey + "']/../../..//input[@class='property-value']")));
        Assert.assertThat((Object)el.getValue(), (Matcher)Matchers.is((Object)expectedValue));
    }
}

