/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webdriver;

import org.hamcrest.Matcher;
import org.neo4j.server.webdriver.Condition;
import org.neo4j.server.webdriver.WebdriverConditionTimeoutException;
import org.openqa.selenium.WebDriver;

public class WebdriverCondition<T>
extends Condition<T> {
    private final WebDriver d;

    public WebdriverCondition(WebDriver d, Matcher<T> matcher, T state) {
        super(matcher, state);
        this.d = d;
    }

    @Override
    public void waitUntilFulfilled(long timeout, String errorMessage) {
        try {
            super.waitUntilFulfilled(timeout, errorMessage);
        }
        catch (WebdriverConditionTimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WebdriverConditionTimeoutException("Webdriver condition failed (" + e.getMessage() + "), see nested exception. HTML dump follows:\n\n" + this.d.getPageSource() + "\n\n", this.d.getPageSource(), e);
        }
    }
}

