/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugin.gremlin;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.server.plugin.gremlin.EngineReplacementDecision;

public class ScriptCountingEngineReplacementDecision
implements EngineReplacementDecision {
    private final Set<String> scripts = new HashSet<String>();
    private final int maxScriptCount;

    public ScriptCountingEngineReplacementDecision(int maxScriptCount) {
        this.maxScriptCount = maxScriptCount;
    }

    @Override
    public boolean mustReplaceEngine() {
        if (this.scripts.size() < this.maxScriptCount) {
            return false;
        }
        this.scripts.clear();
        return true;
    }

    @Override
    public void beforeExecution(String script) {
        this.scripts.add(script);
    }
}

