/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.neo4j.util;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jEdge;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jGraph;
import java.util.Iterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public class Neo4jGraphEdgeSequence
implements Iterator<Edge>,
Iterable<Edge> {
    private final Neo4jGraph graph;
    private final Iterator<Node> nodes;
    private Iterator<Relationship> currentRelationships;
    private boolean complete = false;

    public Neo4jGraphEdgeSequence(Iterable<Node> nodes, Neo4jGraph graph) {
        this.graph = graph;
        this.nodes = nodes.iterator();
        this.complete = this.goToNextEdge();
    }

    @Override
    public Edge next() {
        Neo4jEdge edge = new Neo4jEdge(this.currentRelationships.next(), this.graph);
        this.complete = this.goToNextEdge();
        return edge;
    }

    @Override
    public boolean hasNext() {
        return !this.complete;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private boolean goToNextEdge() {
        do {
            if (this.currentRelationships != null && this.currentRelationships.hasNext()) continue;
            if (this.nodes.hasNext()) {
                this.currentRelationships = this.nodes.next().getRelationships(Direction.OUTGOING).iterator();
                continue;
            }
            return true;
        } while (!this.currentRelationships.hasNext());
        return false;
    }

    @Override
    public Iterator<Edge> iterator() {
        return this;
    }
}

