/*
 * Decompiled with CFR 0.152.
 */
package play.modules.neo4j;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.classloading.ApplicationClasses;
import play.modules.neo4j.model.Neo4jModel;
import play.modules.neo4j.model.Neo4jModelEnhancer;
import play.modules.neo4j.util.Binder;
import play.modules.neo4j.util.Neo4j;
import play.mvc.Router;

public class Neo4jPlugin
extends PlayPlugin {
    public void onApplicationStart() {
        Logger.info((String)"Starting neo4j database", (Object[])new Object[0]);
        if (Neo4j.db() == null) {
            Neo4j.initialize();
            Neo4jPlugin.registerShutdownHook(Neo4j.db());
        }
    }

    public void onApplicationStop() {
        Logger.info((String)"Shutdown neo4j database", (Object[])new Object[0]);
        Neo4j.destroy();
    }

    public void enhance(ApplicationClasses.ApplicationClass appClass) throws Exception {
        new Neo4jModelEnhancer().enhanceThisClass(appClass);
    }

    public void onRoutesLoaded() {
        if (Play.mode == Play.Mode.DEV) {
            Logger.debug((String)"adding routes for Neo4j plugin", (Object[])new Object[0]);
            Router.addRoute((String)"GET", (String)"/@neo4j/console", (String)"controllers.module.neo4j.Neo4jController.console");
        }
    }

    public Object bind(String name, Class clazz, Type type, Annotation[] annotations, Map<String, String[]> params) {
        if (Neo4jModel.class.isAssignableFrom(clazz)) {
            Binder binder = new Binder(clazz);
            return binder.bind(name, params);
        }
        return null;
    }

    public Object bind(String name, Object o, Map<String, String[]> params) {
        if (Neo4jModel.class.isAssignableFrom(o.getClass())) {
            Binder binder = new Binder(o.getClass());
            return binder.bind(name, params);
        }
        return null;
    }

    private static void registerShutdownHook(final GraphDatabaseService graphDb) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                graphDb.shutdown();
            }
        });
    }
}

