/*
 * Decompiled with CFR 0.152.
 */
package play.modules.neo4j.model;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.helpers.collection.MapUtil;
import play.Logger;
import play.modules.neo4j.annotation.Neo4jIndex;
import play.modules.neo4j.annotation.Neo4jRelatedTo;
import play.modules.neo4j.exception.Neo4jException;
import play.modules.neo4j.exception.Neo4jPlayException;
import play.modules.neo4j.model.Neo4jModel;
import play.modules.neo4j.util.Binder;
import play.modules.neo4j.util.Neo4j;
import play.modules.neo4j.util.Neo4jUtils;

public class Neo4jFactory {
    private static Node referenceNode;
    private static RelationshipType root2ref;
    private static RelationshipType ref2node;
    private Class clazz;
    public static final String NODE_KEY_COUNTER = "KEY_COUNTER";
    public static final String NODE_CLASS_NAME = "CLASSNAME";
    private static final String REFERENCE_KEYWORD = "_REF";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Neo4jFactory(Class clazz) {
        this.clazz = clazz;
        GraphDatabaseService graphDb = Neo4j.db();
        if (this.clazz == null || this.clazz.getSimpleName() == null) {
            throw new Neo4jPlayException("Factory class that extends AbstractNeo4jFactory must have the annotation @Neo4jFactory correctly configure !!!");
        }
        String className = this.clazz.getSimpleName().toUpperCase();
        root2ref = DynamicRelationshipType.withName((String)(className + REFERENCE_KEYWORD));
        ref2node = DynamicRelationshipType.withName((String)className);
        RelationshipType[] relationshipTypeArray = new RelationshipType[1];
        relationshipTypeArray[0] = root2ref;
        if (!graphDb.getReferenceNode().hasRelationship(relationshipTypeArray)) {
            Logger.info((String)("Reference node doesn't exist for factory " + this.getClass().getSimpleName() + ", we create it"), (Object[])new Object[0]);
            Transaction tx = graphDb.beginTx();
            try {
                Node node = graphDb.createNode();
                node.setProperty(NODE_KEY_COUNTER, (Object)new Long(1L));
                node.setProperty(NODE_CLASS_NAME, (Object)clazz.getName());
                graphDb.getReferenceNode().createRelationshipTo(node, root2ref);
                tx.success();
            }
            finally {
                tx.finish();
            }
        }
        for (Relationship relationship : graphDb.getReferenceNode().getRelationships(root2ref, Direction.OUTGOING)) {
            referenceNode = relationship.getEndNode();
        }
    }

    public Node getByKey(Long key, String indexName) {
        Index indexNode = Neo4j.db().index().forNodes(indexName);
        Node node = (Node)indexNode.get("key", (Object)key).getSingle();
        return node;
    }

    public <T extends Neo4jModel> List<T> findAll() throws Neo4jException {
        ArrayList elements = new ArrayList();
        for (Relationship relationship : referenceNode.getRelationships(ref2node, Direction.OUTGOING)) {
            Node endNode = relationship.getEndNode();
            Object model = Neo4jModel.getByNode(endNode);
            elements.add(model);
        }
        return elements;
    }

    public Neo4jModel saveAndIndex(Neo4jModel nodeWrapper) throws Neo4jException {
        HashMap<String, Object> oldValues = new HashMap<String, Object>();
        Transaction tx = Neo4j.db().beginTx();
        Boolean isNewNode = Boolean.FALSE;
        if (nodeWrapper.getNode() == null) {
            isNewNode = Boolean.TRUE;
        }
        try {
            if (isNewNode.booleanValue()) {
                nodeWrapper.setKey(this.getNextId());
                nodeWrapper.setNode(Neo4j.db().createNode());
            }
            for (Field field : nodeWrapper.getClass().getFields()) {
                if (field.getName().equals("node") || field.getName().equals("shouldBeSave") || field.get(nodeWrapper) == null) continue;
                if (!field.isAnnotationPresent(Neo4jRelatedTo.class)) {
                    Object oldValue = nodeWrapper.getNode().getProperty(field.getName(), null);
                    if (oldValue != null) {
                        oldValues.put(field.getName(), oldValue);
                    }
                    nodeWrapper.getNode().setProperty(field.getName(), Binder.bindToNeo4jFormat(field.get(nodeWrapper), field.getType()));
                    continue;
                }
                Neo4jRelatedTo neo4jRelatedTo = field.getAnnotation(Neo4jRelatedTo.class);
                Direction relationDirection = Direction.valueOf((String)neo4jRelatedTo.direction());
                DynamicRelationshipType relationType = DynamicRelationshipType.withName((String)neo4jRelatedTo.value());
                HashMap<String, Relationship> dbMapRelations = new HashMap<String, Relationship>();
                Iterable dbNodeRlation = nodeWrapper.getNode().getRelationships(relationDirection, new RelationshipType[]{relationType});
                for (Relationship relation : dbNodeRlation) {
                    dbMapRelations.put(relation.getStartNode().getId() + "@" + relation.getEndNode().getId(), relation);
                }
                TreeMap dbMapRelationsStack = new TreeMap(dbMapRelations);
                List relations = (List)field.get(nodeWrapper);
                for (Neo4jModel related : relations) {
                    Node endNode;
                    Node startNode;
                    if (relationDirection.equals((Object)Direction.INCOMING)) {
                        startNode = related.node;
                        endNode = nodeWrapper.getNode();
                    } else {
                        startNode = nodeWrapper.getNode();
                        endNode = related.node;
                    }
                    if (dbMapRelationsStack.containsKey(startNode.getId() + "@" + endNode.getId())) {
                        dbMapRelationsStack.remove(startNode.getId() + "@" + endNode.getId());
                        continue;
                    }
                    if (dbMapRelations.containsKey(startNode.getId() + "@" + endNode.getId())) continue;
                    startNode.createRelationshipTo(endNode, (RelationshipType)relationType);
                }
                if (dbMapRelationsStack.size() == 0) continue;
                for (Relationship relation : dbMapRelationsStack.values()) {
                    relation.delete();
                }
            }
            if (isNewNode.booleanValue()) {
                referenceNode.createRelationshipTo(nodeWrapper.getNode(), ref2node);
            }
            for (Field field : nodeWrapper.getClass().getFields()) {
                if (!Neo4jUtils.isIndexedField(field)) continue;
                this.indexNodeField(nodeWrapper, field, oldValues.get(field.getName()));
            }
            tx.success();
        }
        catch (IllegalArgumentException e) {
            throw new Neo4jException(e);
        }
        catch (IllegalAccessException e) {
            throw new Neo4jException(e);
        }
        finally {
            tx.finish();
        }
        return nodeWrapper;
    }

    private void indexNodeField(Neo4jModel nodeWrapper, Field field, Object oldValue) throws IllegalAccessException {
        String indexName = Neo4jUtils.getIndexName(nodeWrapper.getClass().getSimpleName(), field);
        if (indexName != null && field.get(nodeWrapper) != null) {
            Index indexNode = Neo4j.db().index().forNodes(indexName, this.getLuceneConfigParam(field));
            if (oldValue != null) {
                indexNode.remove((PropertyContainer)nodeWrapper.getNode(), field.getName(), (Object)oldValue.toString());
            }
            indexNode.add((PropertyContainer)nodeWrapper.getNode(), field.getName(), (Object)field.get(nodeWrapper).toString());
        }
    }

    private Map<String, String> getLuceneConfigParam(Field field) {
        Neo4jIndex nodeIndex = field.getAnnotation(Neo4jIndex.class);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("provider", "lucene");
        params.put("type", nodeIndex.type());
        if (nodeIndex.type().equals("fulltext") && nodeIndex.lowerCase() != "") {
            return MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", nodeIndex.type(), "to_lower_case", nodeIndex.lowerCase()});
        }
        return MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", nodeIndex.type()});
    }

    public Neo4jModel delete(Neo4jModel nodeWrapper) throws Neo4jException {
        return this._delete(nodeWrapper, Boolean.FALSE);
    }

    public Neo4jModel forceDelete(Neo4jModel nodeWrapper) throws Neo4jException {
        return this._delete(nodeWrapper, Boolean.TRUE);
    }

    private Neo4jModel _delete(Neo4jModel nodeWrapper, Boolean forceDelete) throws Neo4jException {
        if (nodeWrapper.getNode() == null) {
            return null;
        }
        Transaction tx = Neo4j.db().beginTx();
        try {
            Node node = nodeWrapper.getNode();
            if (!forceDelete.booleanValue()) {
                for (Relationship relation : node.getRelationships(ref2node, Direction.INCOMING)) {
                    relation.delete();
                }
            } else {
                for (Relationship relation : node.getRelationships()) {
                    relation.delete();
                }
            }
            node.delete();
            for (Field field : nodeWrapper.getClass().getFields()) {
                String indexName;
                if (!Neo4jUtils.isIndexedField(field) || (indexName = Neo4jUtils.getIndexName(nodeWrapper.getClass().getSimpleName(), field)) == null) continue;
                Index indexNode = Neo4j.db().index().forNodes(indexName);
                indexNode.remove((PropertyContainer)nodeWrapper.getNode());
            }
            tx.success();
        }
        catch (Exception e) {
            throw new Neo4jPlayException(e);
        }
        finally {
            tx.finish();
        }
        return nodeWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Long getNextId() {
        Long counter = null;
        try {
            counter = (Long)referenceNode.getProperty(NODE_KEY_COUNTER);
        }
        catch (NotFoundException e) {
            counter = 0L;
        }
        Transaction tx = Neo4j.db().beginTx();
        try {
            referenceNode.setProperty(NODE_KEY_COUNTER, (Object)new Long(counter + 1L));
            Logger.debug((String)("New ID for factory " + this.getClass().getSimpleName() + " is " + counter), (Object[])new Object[0]);
            tx.success();
        }
        finally {
            tx.finish();
        }
        return counter;
    }
}

