/*
 * Decompiled with CFR 0.152.
 */
package play.modules.neo4j.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import play.Logger;
import play.Play;
import play.modules.neo4j.annotation.Neo4jIndex;
import play.modules.neo4j.annotation.Neo4jRelatedTo;
import play.modules.neo4j.exception.Neo4jException;
import play.modules.neo4j.exception.Neo4jPlayException;
import play.modules.neo4j.model.Neo4jFactory;
import play.modules.neo4j.relationship.Neo4jRelationFactory;
import play.modules.neo4j.util.Neo4j;
import play.modules.neo4j.util.Neo4jUtils;

public abstract class Neo4jModel {
    @Neo4jIndex
    public Long key;
    public Node node;
    public Boolean shouldBeSave = Boolean.FALSE;

    public Neo4jModel() {
        this.initializeRelations();
    }

    private void initializeRelations() {
        for (Field field : this.getClass().getFields()) {
            Neo4jRelatedTo relatedTo = field.getAnnotation(Neo4jRelatedTo.class);
            if (relatedTo == null || this.node == null || relatedTo.lazy()) continue;
            try {
                field.set(this, Neo4jRelationFactory.getModelsFromRelatedTo(relatedTo.value(), "" + relatedTo.direction(), field, this.node));
            }
            catch (IllegalAccessException e) {
                Logger.error((String)e.getMessage(), (Object[])new Object[0]);
            }
        }
    }

    public Long getKey() {
        if (this.node != null && this.node.getProperty("key", null) != null) {
            return (Long)this.node.getProperty("key", null);
        }
        return this.key;
    }

    public void setKey(Long id) {
        this.key = id;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public Boolean getShouldBeSave() {
        return this.shouldBeSave;
    }

    public <T extends Neo4jModel> T save() throws Neo4jException {
        this._save();
        return (T)this;
    }

    private void _save() throws Neo4jException {
        Neo4jFactory factory = Neo4jModel.getFactory(this.getClass());
        Neo4jModel model = factory.saveAndIndex(this);
        this.node = model.getNode();
        this.key = model.key;
        this.shouldBeSave = Boolean.FALSE;
    }

    public <T extends Neo4jModel> T delete() throws Neo4jException {
        this._delete();
        return (T)this;
    }

    private void _delete() throws Neo4jException {
        Neo4jFactory factory = Neo4jModel.getFactory(this.getClass());
        factory.forceDelete(this);
        this.node = null;
    }

    public static <T extends Neo4jModel> List<T> findAll() {
        throw new Neo4jPlayException("findAll() Must be overriden by Neo4jModelEnhancer");
    }

    protected static <T extends Neo4jModel> List<T> _findAll(String className) throws Neo4jException {
        List<Object> elements = new ArrayList();
        Neo4jFactory factory = Neo4jModel.getFactory(className);
        elements = factory.findAll();
        return elements;
    }

    public static <T extends Neo4jModel> List<T> queryIndex(String indexname, String query) {
        throw new Neo4jPlayException("queryIndex() Must be overriden by Neo4jModelEnhancer");
    }

    protected static <T extends Neo4jModel> List<T> _queryIndex(String indexname, String query) throws Neo4jException {
        ArrayList<T> elements = new ArrayList<T>();
        IndexManager index = Neo4j.db().index();
        Index indexNodes = index.forNodes(indexname);
        for (Node node : indexNodes.query((Object)query)) {
            T element = Neo4jModel.getByNode(node);
            elements.add(element);
        }
        return elements;
    }

    public static <T extends Neo4jModel> T getByKey(Long key) throws Neo4jException {
        throw new Neo4jPlayException("getByKey() Must be overriden by Neo4jModelEnhancer");
    }

    protected static <T extends Neo4jModel> T _getByKey(Long key, String className) throws Neo4jException {
        Class clazz = Play.classes.getApplicationClass((String)className).javaClass;
        Neo4jFactory factory = Neo4jModel.getFactory(clazz);
        Node node = factory.getByKey(key, Neo4jUtils.getIndexName(clazz.getSimpleName(), "key"));
        return Neo4jModel.getByNode(node);
    }

    public static <T extends Neo4jModel> T getByNode(Node node) throws Neo4jException {
        Class clazz = Neo4jUtils.getClassNameFromNode(node);
        Neo4jModel nodeWrapper = null;
        try {
            Constructor c = clazz.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            nodeWrapper = (Neo4jModel)c.newInstance(new Object[0]);
            Method setNode = clazz.getMethod("setNode", Node.class);
            setNode.invoke((Object)nodeWrapper, node);
            nodeWrapper.initializeRelations();
        }
        catch (Exception e) {
            throw new Neo4jException(e);
        }
        return (T)nodeWrapper;
    }

    protected static Neo4jFactory getFactory(Class clazz) throws Neo4jException {
        Neo4jFactory factory = null;
        try {
            factory = new Neo4jFactory(clazz);
        }
        catch (Exception e) {
            throw new Neo4jException(e);
        }
        return factory;
    }

    private static Neo4jFactory getFactory(String className) throws Neo4jException {
        Class clazz = Play.classes.getApplicationClass((String)className).javaClass;
        return Neo4jModel.getFactory(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (!this.node.hasRelationship()) {
            Transaction tx = Neo4j.db().beginTx();
            try {
                this.node.delete();
                tx.success();
            }
            finally {
                tx.finish();
            }
        }
    }
}

