/*
 * Decompiled with CFR 0.152.
 */
package play.modules.neo4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import play.Logger;
import play.classloading.enhancers.PropertiesEnhancer;
import play.db.jpa.Blob;
import play.modules.neo4j.exception.Neo4jPlayException;
import play.modules.neo4j.model.Neo4jModel;

public class Binder {
    static final int notaccessibleMethod = 264;
    private Class clazz;
    public Map<String, Method> properties = new HashMap<String, Method>();

    public Binder(Class clazz) {
        Method[] classMethods;
        this.clazz = clazz;
        for (Method method : classMethods = this.clazz.getMethods()) {
            if (!this.isSetter(method)) continue;
            String propertyname = method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
            this.properties.put(propertyname, method);
        }
    }

    private boolean isSetter(Method method) {
        return !method.isAnnotationPresent(PropertiesEnhancer.PlayPropertyAccessor.class) && method.getName().startsWith("set") && method.getName().length() > 3 && method.getParameterTypes().length == 1 && (method.getModifiers() & 0x108) == 0;
    }

    public Object bind(String name, Map<String, String[]> params) {
        return this.bind(name, null, params);
    }

    public Object bind(String name, Object o, Map<String, String[]> params) {
        try {
            Neo4jModel model = (Neo4jModel)o;
            if (model == null) {
                if (params.containsKey(name + ".key") && !params.get(name + ".key")[0].isEmpty()) {
                    Long key = Long.valueOf(params.get(name + ".key")[0]);
                    Method getByKey = this.clazz.getMethod("getByKey", Long.class);
                    model = (Neo4jModel)getByKey.invoke(null, key);
                    Logger.debug((String)("Bind object " + name + " is already on database"), (Object[])new Object[0]);
                } else {
                    Constructor constructor = this.clazz.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    model = (Neo4jModel)constructor.newInstance(new Object[0]);
                    Logger.debug((String)("Bind object " + name + " is a new objects"), (Object[])new Object[0]);
                }
            }
            for (String param : params.keySet()) {
                if (!param.startsWith(name + ".") || param.equals(name + ".key")) continue;
                String paramName = param.replace(name + ".", "");
                if (this.properties.containsKey(paramName)) {
                    Method setter = this.properties.get(paramName);
                    if (setter != null) {
                        Logger.debug((String)("Invoke setter " + paramName + " for bind object " + name), (Object[])new Object[0]);
                        Object value = Binder.bindFromNeo4jFormat(params.get(param)[0], setter.getParameterTypes()[0]);
                        if (String.class.isInstance(value)) {
                            value = play.data.binding.Binder.directBind((String)params.get(param)[0], setter.getParameterTypes()[0]);
                        }
                        if (value == null || value.equals(play.data.binding.Binder.MISSING)) continue;
                        setter.invoke((Object)model, value);
                        continue;
                    }
                    throw new Neo4jPlayException("Setter for " + paramName + " can't be found into Neo4jModel " + this.clazz.getSimpleName());
                }
                throw new Neo4jPlayException("Property " + paramName + " can't be found into Neo4jModel " + this.clazz.getSimpleName());
            }
            return model;
        }
        catch (Exception e) {
            throw new Neo4jPlayException(e.getMessage());
        }
    }

    public static Object bindToNeo4jFormat(Object value, Class type) {
        try {
            if (type.isAssignableFrom(Date.class)) {
                Date date = (Date)value;
                String neo4jValue = "@@Date@@" + date.getTime();
                return neo4jValue;
            }
            if (type.isAssignableFrom(Blob.class)) {
                Blob blob = (Blob)value;
                String format = blob.type();
                String uuid = blob.getFile().getName();
                return "@@File@@" + uuid + "|" + format;
            }
            return value;
        }
        catch (Exception e) {
            throw new Neo4jPlayException(e);
        }
    }

    public static Object bindFromNeo4jFormat(Object value, Class type) {
        try {
            if (value != null) {
                Long dateLong;
                String dateString;
                String temp;
                if (type.isAssignableFrom(Date.class) && (temp = (String)value).startsWith("@@Date@@") && (dateString = temp.replaceFirst("@@Date@@", "")) != null && (dateLong = Long.valueOf(dateString)) != null) {
                    Date date = new Date(dateLong);
                    Logger.debug((String)("Object from neo4j is " + date.toString()), (Object[])new Object[0]);
                    return date;
                }
                if (type.isAssignableFrom(Blob.class) && (temp = (String)value).startsWith("@@File@@")) {
                    String fileString = temp.replaceFirst("@@File@@", "");
                    String UUID = fileString.split("[|]")[0];
                    String format = fileString.split("[|]")[1];
                    if (UUID != null && !UUID.isEmpty() && format != null && !format.isEmpty()) {
                        Blob blob = new Blob();
                        File file = new File(Blob.getStore(), UUID);
                        FileInputStream is = new FileInputStream(file);
                        blob.set((InputStream)is, format);
                        Logger.debug((String)("Object from neo4j is " + blob.toString()), (Object[])new Object[0]);
                        return blob;
                    }
                }
            }
            Logger.debug((String)"Object from neo4j is default", (Object[])new Object[0]);
            return value;
        }
        catch (Exception e) {
            throw new Neo4jPlayException(e);
        }
    }
}

