/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.Util;
import org.rrd4j.data.DataProcessor;
import org.rrd4j.graph.CommentText;
import org.rrd4j.graph.ValueScaler;

class PrintText
extends CommentText {
    static final String UNIT_MARKER = "([^%]?)%(s|S)";
    static final Pattern UNIT_PATTERN = Pattern.compile("([^%]?)%(s|S)");
    private final String srcName;
    private ConsolFun consolFun;
    private final boolean includedInGraph;

    PrintText(String srcName, ConsolFun consolFun, String text, boolean includedInGraph) {
        super(text);
        this.srcName = srcName;
        this.consolFun = consolFun;
        this.includedInGraph = includedInGraph;
    }

    boolean isPrint() {
        return !this.includedInGraph;
    }

    void resolveText(DataProcessor dproc, ValueScaler valueScaler) {
        super.resolveText(dproc, valueScaler);
        if (this.resolvedText != null) {
            double value = dproc.getAggregate(this.srcName, this.consolFun);
            Matcher matcher = UNIT_PATTERN.matcher(this.resolvedText);
            if (matcher.find()) {
                ValueScaler.Scaled scaled = valueScaler.scale(value, matcher.group(2).equals("s"));
                this.resolvedText = this.resolvedText.substring(0, matcher.start()) + matcher.group(1) + scaled.unit + this.resolvedText.substring(matcher.end());
                value = scaled.value;
            }
            this.resolvedText = Util.sprintf(this.resolvedText, value);
            this.trimIfGlue();
        }
    }
}

