/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.udc.impl;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import org.neo4j.ext.udc.impl.Pinger;

public class UdcTimerTask
extends TimerTask {
    public static final Map<String, Integer> successCounts = new HashMap<String, Integer>();
    public static final Map<String, Integer> failureCounts = new HashMap<String, Integer>();
    private final String storeId;
    private final Pinger pinger;

    public UdcTimerTask(String host, String version, String storeId, String source, boolean crashPing) {
        successCounts.put(storeId, 0);
        failureCounts.put(storeId, 0);
        this.storeId = storeId;
        HashMap<String, String> udcFields = new HashMap<String, String>();
        udcFields.put("id", storeId);
        udcFields.put("v", version);
        Map<String, String> params = this.mergeSystemPropertiesWith(udcFields);
        if (source != null) {
            params.put("source", source);
        }
        this.pinger = new Pinger(host, params, crashPing);
    }

    private Map<String, String> mergeSystemPropertiesWith(Map<String, String> udcFields) {
        HashMap<String, String> mergedMap = new HashMap<String, String>();
        mergedMap.putAll(udcFields);
        Properties sysProps = System.getProperties();
        Enumeration<?> sysPropsNames = sysProps.propertyNames();
        while (sysPropsNames.hasMoreElements()) {
            String sysPropName = (String)sysPropsNames.nextElement();
            if (!sysPropName.startsWith("neo4j.ext.udc")) continue;
            mergedMap.put(sysPropName.substring("neo4j.ext.udc".length() + 1), sysProps.get(sysPropName).toString());
        }
        return mergedMap;
    }

    @Override
    public void run() {
        try {
            this.pinger.ping();
            this.incrementSuccessCount(this.storeId);
        }
        catch (IOException e) {
            this.incrementFailureCount(this.storeId);
        }
    }

    private void incrementSuccessCount(String storeId) {
        Integer currentCount;
        Integer n = currentCount = successCounts.get(storeId);
        Integer n2 = currentCount = Integer.valueOf(currentCount + 1);
        successCounts.put(storeId, currentCount);
    }

    private void incrementFailureCount(String storeId) {
        Integer currentCount;
        Integer n = currentCount = failureCounts.get(storeId);
        Integer n2 = currentCount = Integer.valueOf(currentCount + 1);
        failureCounts.put(storeId, currentCount);
    }
}

