/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.ArrayList;
import java.util.Map;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.ObjectRepresentation;
import org.neo4j.server.rest.repr.PathRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public class CypherResultRepresentation
extends ObjectRepresentation {
    private final ExecutionResult queryResult;

    public CypherResultRepresentation(ExecutionResult result) {
        super(RepresentationType.STRING);
        this.queryResult = result;
    }

    @ObjectRepresentation.Mapping(value="columns")
    public Representation columns() {
        return ListRepresentation.string((Iterable)this.queryResult.columns());
    }

    @ObjectRepresentation.Mapping(value="data")
    public Representation data() {
        ArrayList<ListRepresentation> rows = new ArrayList<ListRepresentation>();
        for (Map row : this.queryResult) {
            ArrayList<Representation> fields = new ArrayList<Representation>();
            for (String column : this.queryResult.columns()) {
                Representation rowRep = this.getRepresentation(row.get(column));
                fields.add(rowRep);
            }
            rows.add(new ListRepresentation("row", fields));
        }
        return new ListRepresentation("data", rows);
    }

    private Representation getRepresentation(Object r) {
        if (r == null) {
            return ValueRepresentation.string(null);
        }
        if (r instanceof Node) {
            return new NodeRepresentation((Node)r);
        }
        if (r instanceof Relationship) {
            return new RelationshipRepresentation((Relationship)r);
        }
        if (r instanceof Double || r instanceof Float) {
            return ValueRepresentation.number((double)((Number)r).doubleValue());
        }
        if (r instanceof Long || r instanceof Integer) {
            return ValueRepresentation.number((long)((Number)r).longValue());
        }
        if (r instanceof Path) {
            return new PathRepresentation((Path)r);
        }
        return ValueRepresentation.string((String)r.toString());
    }
}

