/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.ArrayList;
import java.util.Map;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.ObjectRepresentation;
import org.neo4j.server.rest.repr.PathRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public class JSONTableRepresentation
extends ObjectRepresentation {
    private final ExecutionResult queryResult;

    public JSONTableRepresentation(ExecutionResult result) {
        super(RepresentationType.STRING);
        this.queryResult = result;
    }

    @ObjectRepresentation.Mapping(value="cols")
    public Representation columns() {
        ArrayList<ValueRepresentation> cols = new ArrayList<ValueRepresentation>();
        for (String col : this.queryResult.columns()) {
            cols.add(ValueRepresentation.string((String)String.format("{id: '%s', label:'%s', type:'string'}", col, col)));
        }
        return new ListRepresentation("hej", cols);
    }

    @ObjectRepresentation.Mapping(value="rows")
    public Representation data() {
        ArrayList<ValueRepresentation> cells = new ArrayList<ValueRepresentation>();
        for (Map row : this.queryResult) {
            for (String column : this.queryResult.columns()) {
                cells.add(ValueRepresentation.string((String)String.format("{c: [{v:'%s'}]}", row.get(column) != null ? row.get(column).toString() : null)));
            }
        }
        return new ListRepresentation("cells", cells);
    }

    private Representation getRepresentation(Object r) {
        if (r == null) {
            return ValueRepresentation.string(null);
        }
        if (r instanceof Node) {
            return new NodeRepresentation((Node)r);
        }
        if (r instanceof Relationship) {
            return new RelationshipRepresentation((Relationship)r);
        }
        if (r instanceof Double || r instanceof Float) {
            return ValueRepresentation.number((double)((Number)r).doubleValue());
        }
        if (r instanceof Long || r instanceof Integer) {
            return ValueRepresentation.number((long)((Number)r).longValue());
        }
        if (r instanceof Path) {
            return new PathRepresentation((Path)r);
        }
        return ValueRepresentation.string((String)r.toString());
    }
}

