/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.event;

import com.tinkerpop.blueprints.pgm.CloseableSequence;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.Index;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.impls.event.EventElement;
import com.tinkerpop.blueprints.pgm.impls.event.listener.GraphChangedListener;
import com.tinkerpop.blueprints.pgm.impls.event.util.EventEdgeSequence;
import com.tinkerpop.blueprints.pgm.impls.event.util.EventVertexSequence;
import java.util.List;

public class EventIndex<T extends Element>
implements Index<T> {
    protected final Index<T> rawIndex;
    protected final List<GraphChangedListener> graphChangedListeners;

    public EventIndex(Index<T> rawIndex, List<GraphChangedListener> graphChangedListeners) {
        this.rawIndex = rawIndex;
        this.graphChangedListeners = graphChangedListeners;
    }

    @Override
    public void remove(String key, Object value, T element) {
        this.rawIndex.remove(key, value, ((EventElement)element).getRawElement());
    }

    @Override
    public void put(String key, Object value, T element) {
        this.rawIndex.put(key, value, ((EventElement)element).getRawElement());
    }

    @Override
    public CloseableSequence<T> get(String key, Object value) {
        if (Vertex.class.isAssignableFrom(this.getIndexClass())) {
            return new EventVertexSequence(this.rawIndex.get(key, value).iterator(), this.graphChangedListeners);
        }
        return new EventEdgeSequence(this.rawIndex.get(key, value).iterator(), this.graphChangedListeners);
    }

    @Override
    public long count(String key, Object value) {
        return this.rawIndex.count(key, value);
    }

    @Override
    public Index.Type getIndexType() {
        return Index.Type.MANUAL;
    }

    @Override
    public String getIndexName() {
        return this.rawIndex.getIndexName();
    }

    @Override
    public Class<T> getIndexClass() {
        return this.rawIndex.getIndexClass();
    }

    public String toString() {
        return StringFactory.indexString(this);
    }
}

