/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util.graphml;

import com.tinkerpop.blueprints.pgm.Graph;
import com.tinkerpop.blueprints.pgm.util.graphml.GraphMLReader;
import com.tinkerpop.blueprints.pgm.util.graphml.GraphMLWriter;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.xml.stream.XMLStreamException;

public class GraphMigrator {
    public static void migrateGraph(final Graph fromGraph, Graph toGraph) throws XMLStreamException, IOException {
        final PipedInputStream inPipe = new PipedInputStream(){
            protected static final int PIPE_SIZE = 1024;
        };
        final PipedOutputStream outPipe = new PipedOutputStream(inPipe){

            @Override
            public void close() throws IOException {
                while (inPipe.available() > 0) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                super.close();
            }
        };
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    GraphMLWriter.outputGraph(fromGraph, outPipe);
                    outPipe.flush();
                    outPipe.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
        GraphMLReader.inputGraph(toGraph, inPipe);
    }
}

