/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.server.Bootstrapper;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.GraphDatabaseFactory;
import org.neo4j.server.guard.Guard;
import org.neo4j.server.guard.GuardedDatabaseFactory;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.modules.PluginInitializer;
import org.neo4j.server.modules.RESTApiModule;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.plugins.Injectable;
import org.neo4j.server.plugins.PluginManager;
import org.neo4j.server.rest.security.SecurityRule;
import org.neo4j.server.startup.healthcheck.StartupHealthCheck;
import org.neo4j.server.startup.healthcheck.StartupHealthCheckFailedException;
import org.neo4j.server.web.WebServer;

public class NeoServerWithEmbeddedWebServer
implements NeoServer {
    public static final Logger log = Logger.getLogger(NeoServerWithEmbeddedWebServer.class);
    private Database database;
    private final Configurator configurator;
    private final WebServer webServer;
    private final StartupHealthCheck startupHealthCheck;
    private final List<ServerModule> serverModules = new ArrayList<ServerModule>();
    private PluginInitializer pluginInitializer;
    private final Bootstrapper bootstrapper;
    private Guard guard;

    public NeoServerWithEmbeddedWebServer(Bootstrapper bootstrapper, StartupHealthCheck startupHealthCheck, Configurator configurator, WebServer webServer, Iterable<Class<? extends ServerModule>> moduleClasses) {
        this.bootstrapper = bootstrapper;
        this.startupHealthCheck = startupHealthCheck;
        this.configurator = configurator;
        this.webServer = webServer;
        webServer.setNeoServer(this);
        for (Class<? extends ServerModule> moduleClass : moduleClasses) {
            this.registerModule(moduleClass);
        }
    }

    @Override
    public void start() {
        this.startupHealthCheck();
        this.initGuard();
        this.initWebServer();
        DiagnosticsManager dm = this.startDatabase();
        StringLogger logger = dm.getTargetLog();
        logger.logMessage("--- SERVER STARTUP START ---");
        dm.register(Configurator.DIAGNOSTICS, (Object)this.configurator);
        this.startExtensionInitialization();
        this.startModules(logger);
        this.startWebServer(logger);
        logger.logMessage("--- SERVER STARTUP END ---", true);
    }

    protected void startExtensionInitialization() {
        this.pluginInitializer = new PluginInitializer(this);
    }

    protected final void registerModule(Class<? extends ServerModule> clazz) {
        try {
            this.serverModules.add(clazz.newInstance());
        }
        catch (Exception e) {
            log.warn("Failed to instantiate server module [%s], reason: %s", clazz.getName(), e.getMessage());
        }
    }

    private void startModules(StringLogger logger) {
        for (ServerModule module : this.serverModules) {
            module.start(this, logger);
        }
    }

    private void stopModules() {
        for (ServerModule module : this.serverModules) {
            try {
                module.stop();
            }
            catch (Exception e) {
                log.error(e);
            }
        }
    }

    private void startupHealthCheck() {
        if (!this.startupHealthCheck.run()) {
            throw new StartupHealthCheckFailedException(this.startupHealthCheck.failedRule());
        }
    }

    private DiagnosticsManager startDatabase() {
        Map<String, String> databaseTuningProperties;
        String dbLocation = new File(this.configurator.configuration().getString("org.neo4j.server.database.location")).getAbsolutePath();
        GraphDatabaseFactory dbFactory = this.bootstrapper.getGraphDatabaseFactory(this.configurator.configuration());
        if (this.guard != null) {
            dbFactory = new GuardedDatabaseFactory(dbFactory, this.guard);
        }
        this.database = (databaseTuningProperties = this.configurator.getDatabaseTuningProperties()) != null ? new Database(dbFactory, dbLocation, databaseTuningProperties) : new Database(dbFactory, dbLocation);
        return this.database.graph.getConfig().getDiagnosticsManager();
    }

    private void initGuard() {
        Integer limit = this.getConfiguration().getInteger("org.neo4j.server.webserver.limit.executiontime", null);
        this.guard = limit != null ? new Guard(limit) : null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configurator.configuration();
    }

    private void initWebServer() {
        int webServerPort = this.getWebServerPort();
        String webServerAddr = this.getWebServerAddress();
        int maxThreads = this.getMaxThreads();
        log.info("Starting Neo Server on port [%s] with [%d] threads available", webServerPort, maxThreads);
        this.webServer.setPort(webServerPort);
        this.webServer.setAddress(webServerAddr);
        this.webServer.setMaxThreads(maxThreads);
        this.webServer.init();
    }

    private SecurityRule[] createSecurityRulesFrom(Configuration configuration) {
        ArrayList<SecurityRule> rules = new ArrayList<SecurityRule>();
        for (String classname : configuration.getStringArray("org.neo4j.server.rest.security_rules")) {
            try {
                rules.add((SecurityRule)Class.forName(classname).newInstance());
            }
            catch (Exception e) {
                log.error("Could not load server security rule [%s], exception details: ", classname, e.getMessage());
                e.printStackTrace();
            }
        }
        return rules.toArray(new SecurityRule[0]);
    }

    private int getMaxThreads() {
        return this.configurator.configuration().containsKey("org.neo4j.server.webserver.maxthreads") ? this.configurator.configuration().getInt("org.neo4j.server.webserver.maxthreads") : this.defaultMaxWebServerThreads();
    }

    private int defaultMaxWebServerThreads() {
        return 10 * Runtime.getRuntime().availableProcessors();
    }

    private void startWebServer(StringLogger logger) {
        try {
            SecurityRule[] securityRules = this.createSecurityRulesFrom(this.configurator.configuration());
            if (logger != null) {
                for (SecurityRule rule : securityRules) {
                    logger.logMessage("Active Security Rule: " + rule.getClass());
                }
            }
            this.webServer.addSecurityRules(securityRules);
            if (this.guard != null) {
                this.webServer.addExecutionLimitFilter(this.guard);
            }
            this.webServer.start();
            if (logger != null) {
                logger.logMessage("Server started on: " + this.baseUri());
            }
            log.info("Server started on [%s]", this.baseUri());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed to start Neo Server on port [%d], reason [%s]", this.getWebServerPort(), e.getMessage());
        }
    }

    protected int getWebServerPort() {
        return this.configurator.configuration().getInt("org.neo4j.server.webserver.port", 7474);
    }

    protected String getWebServerAddress() {
        return this.configurator.configuration().getString("org.neo4j.server.webserver.address", "localhost");
    }

    @Override
    public void stop() {
        try {
            this.stopServer();
            this.stopDatabase();
            log.info("Successfully shutdown database [%s]", this.getDatabase().getLocation());
        }
        catch (Exception e) {
            log.warn("Failed to cleanly shutdown database [%s]. Reason: %s", this.getDatabase().getLocation(), e.getMessage());
        }
    }

    public void stopServer() {
        try {
            this.stopWebServer();
            this.stopModules();
            this.stopExtensionInitializers();
            log.info("Successfully shutdown Neo Server on port [%d]", this.getWebServerPort(), this.getDatabase().getLocation());
        }
        catch (Exception e) {
            log.warn("Failed to cleanly shutdown Neo Server on port [%d], database [%s]. Reason: %s", this.getWebServerPort(), this.getDatabase().getLocation(), e.getMessage());
        }
    }

    private void stopExtensionInitializers() {
        this.pluginInitializer.stop();
    }

    private void stopWebServer() {
        if (this.webServer != null) {
            this.webServer.stop();
        }
    }

    private void stopDatabase() {
        if (this.database != null) {
            this.database.shutdown();
        }
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public URI baseUri() {
        StringBuilder sb = new StringBuilder();
        sb.append("http");
        int webServerPort = this.getWebServerPort();
        if (webServerPort == 443) {
            sb.append("s");
        }
        sb.append("://");
        sb.append(this.getWebServerAddress());
        if (webServerPort != 80 && webServerPort != 443) {
            sb.append(":");
            sb.append(webServerPort);
        }
        sb.append("/");
        try {
            return new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    @Override
    public Configurator getConfigurator() {
        return this.configurator;
    }

    @Override
    public PluginManager getExtensionManager() {
        if (this.hasModule(RESTApiModule.class)) {
            return this.getModule(RESTApiModule.class).getPlugins();
        }
        return null;
    }

    @Override
    public Collection<Injectable<?>> getInjectables(List<String> packageNames) {
        return this.pluginInitializer.initializePackages(packageNames);
    }

    private boolean hasModule(Class<? extends ServerModule> clazz) {
        for (ServerModule sm : this.serverModules) {
            if (sm.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    private <T extends ServerModule> T getModule(Class<T> clazz) {
        for (ServerModule sm : this.serverModules) {
            if (sm.getClass() != clazz) continue;
            return (T)sm;
        }
        return null;
    }
}

