/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.guard;

import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.server.database.GraphDatabaseFactory;
import org.neo4j.server.guard.Guard;
import org.neo4j.tooling.wrap.WrappedGraphDatabase;
import org.neo4j.tooling.wrap.WrappedNode;
import org.neo4j.tooling.wrap.WrappedRelationship;

public class GuardedDatabaseFactory
implements GraphDatabaseFactory {
    private final GraphDatabaseFactory dbFactory;
    private final Guard guard;

    public GuardedDatabaseFactory(GraphDatabaseFactory dbFactory, Guard guard) {
        this.dbFactory = dbFactory;
        this.guard = guard;
    }

    @Override
    public AbstractGraphDatabase createDatabase(String databaseStoreDirectory, Map<String, String> databaseProperties) {
        AbstractGraphDatabase db = this.dbFactory.createDatabase(databaseStoreDirectory, databaseProperties);
        return new WrappedGraphDatabase((GraphDatabaseService)db){

            protected WrappedNode<WrappedGraphDatabase> node(final Node node, boolean created) {
                GuardedDatabaseFactory.this.guard.check();
                return new WrappedNode<WrappedGraphDatabase>((WrappedGraphDatabase)this){

                    protected Node actual() {
                        return node;
                    }
                };
            }

            protected WrappedRelationship<WrappedGraphDatabase> relationship(final Relationship relationship, boolean created) {
                GuardedDatabaseFactory.this.guard.check();
                return new WrappedRelationship<WrappedGraphDatabase>((WrappedGraphDatabase)this){

                    protected Relationship actual() {
                        return relationship;
                    }
                };
            }
        };
    }
}

