/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.guard;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.neo4j.server.guard.Guard;
import org.neo4j.server.guard.GuardException;

public class GuardingRequestFilter
implements Filter {
    private final Guard guard;

    public GuardingRequestFilter(Guard guard) {
        this.guard = guard;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            int timeLimit = this.getTimeLimit(request);
            if (timeLimit <= 0) {
                this.guard.clear();
                chain.doFilter(req, res);
            } else {
                this.guard.start(System.currentTimeMillis() + (long)timeLimit);
                try {
                    chain.doFilter(req, res);
                }
                catch (GuardException e) {
                    response.setStatus(408);
                }
                finally {
                    this.guard.stop();
                }
            }
        } else {
            chain.doFilter(req, res);
        }
    }

    public void destroy() {
    }

    private int getTimeLimit(HttpServletRequest request) {
        int timeLimit = this.guard.getTimeLimit();
        String headerValue = request.getHeader("max-execution-time");
        if (headerValue != null) {
            int maxHeader = Integer.parseInt(headerValue);
            if (timeLimit < 0 || maxHeader > 0 && maxHeader < timeLimit) {
                return maxHeader;
            }
        }
        return timeLimit;
    }
}

