/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugins;

import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.server.plugins.ParameterList;
import org.neo4j.server.plugins.TypeCaster;
import org.neo4j.server.rest.repr.BadInputException;

class FloatTypeCaster
extends TypeCaster {
    FloatTypeCaster() {
    }

    @Override
    Object get(AbstractGraphDatabase graphDb, ParameterList parameters, String name) throws BadInputException {
        return parameters.getFloat(name);
    }

    @Override
    Object[] getList(AbstractGraphDatabase graphDb, ParameterList parameters, String name) throws BadInputException {
        return parameters.getFloatList(name);
    }

    float[] convert(Object[] data) throws BadInputException {
        Float[] incoming = (Float[])data;
        float[] result = new float[incoming.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = incoming[i].floatValue();
        }
        return result;
    }
}

