/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugins;

import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.server.plugins.Description;
import org.neo4j.server.plugins.Parameter;
import org.neo4j.server.plugins.ParameterDescriptionConsumer;
import org.neo4j.server.plugins.ParameterExtractor;
import org.neo4j.server.plugins.ParameterList;
import org.neo4j.server.plugins.TypeCaster;
import org.neo4j.server.rest.repr.BadInputException;

abstract class ListParameterExtractor
extends ParameterExtractor {
    ListParameterExtractor(TypeCaster caster, Class<?> type, Parameter param, Description description) {
        super(caster, type, param, description);
    }

    @Override
    Object extract(AbstractGraphDatabase graphDb, Object source, ParameterList parameters) throws BadInputException {
        Object[] result = this.caster.getList(graphDb, parameters, this.name);
        if (result != null) {
            if (this.type.isPrimitive()) {
                return this.caster.convert(result);
            }
            return this.convert(result);
        }
        if (this.optional) {
            return null;
        }
        throw new IllegalArgumentException("Mandatory argument \"" + this.name + "\" not supplied.");
    }

    abstract Object convert(Object[] var1);

    @Override
    void describe(ParameterDescriptionConsumer consumer) {
        consumer.describeListParameter(this.name, this.type, this.optional, this.description);
    }
}

