/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugins;

import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.server.plugins.DataExtractor;
import org.neo4j.server.plugins.Description;
import org.neo4j.server.plugins.Parameter;
import org.neo4j.server.plugins.ParameterDescriptionConsumer;
import org.neo4j.server.plugins.ParameterList;
import org.neo4j.server.plugins.TypeCaster;
import org.neo4j.server.rest.repr.BadInputException;

class ParameterExtractor
extends DataExtractor {
    final String name;
    final Class<?> type;
    final boolean optional;
    final String description;
    final TypeCaster caster;

    ParameterExtractor(TypeCaster caster, Class<?> type, Parameter param, Description description) {
        this.caster = caster;
        this.type = type;
        this.name = param.name();
        this.optional = param.optional();
        this.description = description == null ? "" : description.value();
    }

    @Override
    Object extract(AbstractGraphDatabase graphDb, Object source, ParameterList parameters) throws BadInputException {
        Object result = this.caster.get(graphDb, parameters, this.name);
        if (this.optional || result != null) {
            return result;
        }
        throw new IllegalArgumentException("Mandatory argument \"" + this.name + "\" not supplied.");
    }

    @Override
    void describe(ParameterDescriptionConsumer consumer) {
        consumer.describeParameter(this.name, this.type, this.optional, this.description);
    }
}

