/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugins;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.server.plugins.ParameterList;
import org.neo4j.server.plugins.TypeCaster;
import org.neo4j.server.rest.repr.BadInputException;

class URLTypeCaster
extends TypeCaster {
    URLTypeCaster() {
    }

    @Override
    Object get(AbstractGraphDatabase graphDb, ParameterList parameters, String name) throws BadInputException {
        try {
            return parameters.getUri(name).toURL();
        }
        catch (MalformedURLException e) {
            throw new BadInputException((Throwable)e);
        }
    }

    @Override
    Object[] getList(AbstractGraphDatabase graphDb, ParameterList parameters, String name) throws BadInputException {
        URI[] uris = parameters.getUriList(name);
        Object[] urls = new URL[uris.length];
        try {
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = uris[i].toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new BadInputException((Throwable)e);
        }
        return urls;
    }
}

