/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.paging;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.server.rest.paging.Leasable;

public class PagedTraverser
implements Iterator<List<Path>>,
Iterable<List<Path>>,
Leasable {
    private final int pageSize;
    private Iterator<Path> iterator;

    public PagedTraverser(Traverser traverser, int pageSize) {
        this.iterator = traverser.iterator();
        this.pageSize = pageSize;
    }

    @Override
    public List<Path> next() {
        if (!this.iterator.hasNext()) {
            return null;
        }
        ArrayList<Path> result = new ArrayList<Path>();
        for (int i = 0; i < this.pageSize && this.iterator.hasNext(); ++i) {
            result.add(this.iterator.next());
        }
        return result;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public Iterator<List<Path>> iterator() {
        return this;
    }
}

