/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.ObjectRepresentation;
import org.neo4j.server.rest.repr.PathRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public class CypherResultRepresentation
extends ObjectRepresentation {
    private final ExecutionResult queryResult;

    public CypherResultRepresentation(ExecutionResult result) {
        super(RepresentationType.STRING);
        this.queryResult = result;
    }

    @ObjectRepresentation.Mapping(value="columns")
    public Representation columns() {
        return ListRepresentation.string((Iterable)this.queryResult.columns());
    }

    @ObjectRepresentation.Mapping(value="data")
    public Representation data() {
        ArrayList<ListRepresentation> rows = new ArrayList<ListRepresentation>();
        for (Map row : this.queryResult) {
            ArrayList<Representation> fields = new ArrayList<Representation>();
            for (String column : this.queryResult.columns()) {
                Representation rowRep = this.getRepresentation(row.get(column));
                fields.add(rowRep);
            }
            rows.add(new ListRepresentation("row", fields));
        }
        return new ListRepresentation("data", rows);
    }

    private Representation getRepresentation(Object r) {
        if (r == null) {
            return ValueRepresentation.string(null);
        }
        if (r instanceof Node) {
            return new NodeRepresentation((Node)r);
        }
        if (r instanceof Relationship) {
            return new RelationshipRepresentation((Relationship)r);
        }
        if (r instanceof Double || r instanceof Float) {
            return ValueRepresentation.number((double)((Number)r).doubleValue());
        }
        if (r instanceof Long || r instanceof Integer) {
            return ValueRepresentation.number((long)((Number)r).longValue());
        }
        if (r instanceof Path) {
            return new PathRepresentation<Path>((Path)r);
        }
        if (r instanceof Iterable) {
            return this.getListRepresentation((Iterable)r);
        }
        return ValueRepresentation.string((String)r.toString());
    }

    Representation getListRepresentation(Iterable data) {
        List<Representation> results = this.convertValuesToRepresentations(data);
        return new ListRepresentation(this.getType(results), results);
    }

    List<Representation> convertValuesToRepresentations(Iterable data) {
        ArrayList<Representation> results = new ArrayList<Representation>();
        for (Object value : data) {
            if (value instanceof Iterable) {
                ArrayList<Representation> nested = new ArrayList<Representation>();
                nested.addAll(this.convertValuesToRepresentations((Iterable)value));
                results.add((Representation)new ListRepresentation(this.getType(nested), nested));
                continue;
            }
            results.add(this.getSingleRepresentation(value));
        }
        return results;
    }

    RepresentationType getType(List<Representation> representations) {
        if (representations == null || representations.isEmpty()) {
            return RepresentationType.STRING;
        }
        return representations.get(0).getRepresentationType();
    }

    Representation getSingleRepresentation(Object result) {
        if (result == null) {
            return ValueRepresentation.string((String)"null");
        }
        if (result instanceof Node) {
            return new NodeRepresentation((Node)result);
        }
        if (result instanceof Relationship) {
            return new RelationshipRepresentation((Relationship)result);
        }
        if (result instanceof Double || result instanceof Float) {
            return ValueRepresentation.number((double)((Number)result).doubleValue());
        }
        if (result instanceof Long) {
            return ValueRepresentation.number((long)((Long)result));
        }
        if (result instanceof Integer) {
            return ValueRepresentation.number((int)((Integer)result));
        }
        return ValueRepresentation.string((String)result.toString());
    }
}

