/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.neo4j.cypher.SyntaxException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.server.database.Database;
import org.neo4j.server.plugins.BadPluginInvocationException;
import org.neo4j.server.plugins.ParameterList;
import org.neo4j.server.plugins.PluginInvocationFailureException;
import org.neo4j.server.plugins.PluginInvocator;
import org.neo4j.server.plugins.PluginLookupException;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.ServerExtensionRepresentation;
import org.neo4j.server.rest.web.NodeNotFoundException;
import org.neo4j.server.rest.web.RelationshipNotFoundException;

@Path(value="ext")
public class ExtensionService {
    private static final String PATH_EXTENSION = "/{name}";
    private static final String PATH_GRAPHDB_EXTENSION_METHOD = "/{name}/graphdb/{method}";
    private static final String PATH_NODE_EXTENSION_METHOD = "/{name}/node/{nodeId}/{method}";
    private static final String PATH_RELATIONSHIP_EXTENSION_METHOD = "/{name}/relationship/{relationshipId}/{method}";
    private final InputFormat input;
    private final OutputFormat output;
    private final PluginInvocator extensions;
    private final AbstractGraphDatabase graphDb;

    public ExtensionService(@Context InputFormat input, @Context OutputFormat output, @Context PluginInvocator extensions, @Context Database database) {
        this.input = input;
        this.output = output;
        this.extensions = extensions;
        this.graphDb = database.graph;
    }

    private Node node(long id) throws NodeNotFoundException {
        try {
            return this.graphDb.getNodeById(id);
        }
        catch (NotFoundException e) {
            throw new NodeNotFoundException(e);
        }
    }

    private Relationship relationship(long id) throws RelationshipNotFoundException {
        try {
            return this.graphDb.getRelationshipById(id);
        }
        catch (NotFoundException e) {
            throw new RelationshipNotFoundException();
        }
    }

    @GET
    public Response getExtensionsList() {
        return this.output.ok(this.extensionsList());
    }

    @GET
    @Path(value="/{name}")
    public Response getExtensionList(@PathParam(value="name") String name) {
        try {
            return this.output.ok(this.extensionList(name));
        }
        catch (PluginLookupException e) {
            return this.output.notFound(e);
        }
    }

    @POST
    @Path(value="/{name}/graphdb/{method}")
    public Response invokeGraphDatabaseExtension(@PathParam(value="name") String name, @PathParam(value="method") String method, String data) {
        try {
            return this.output.ok(this.invokeGraphDatabaseExtension(name, method, this.input.readParameterList(data)));
        }
        catch (BadInputException e) {
            return this.output.badRequest(e);
        }
        catch (PluginLookupException e) {
            return this.output.notFound(e);
        }
        catch (BadPluginInvocationException e) {
            return this.output.badRequest(e.getCause());
        }
        catch (SyntaxException e) {
            return this.output.badRequest(e.getCause());
        }
        catch (PluginInvocationFailureException e) {
            return this.output.serverError(e.getCause());
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    @GET
    @Path(value="/{name}/graphdb/{method}")
    public Response getGraphDatabaseExtensionDescription(@PathParam(value="name") String name, @PathParam(value="method") String method) {
        try {
            return this.output.ok(this.describeGraphDatabaseExtension(name, method));
        }
        catch (PluginLookupException e) {
            return this.output.notFound(e);
        }
    }

    @POST
    @Path(value="/{name}/node/{nodeId}/{method}")
    public Response invokeNodeExtension(@PathParam(value="name") String name, @PathParam(value="method") String method, @PathParam(value="nodeId") long nodeId, String data) {
        try {
            return this.output.ok(this.invokeNodeExtension(nodeId, name, method, this.input.readParameterList(data)));
        }
        catch (NodeNotFoundException e) {
            return this.output.notFound(e);
        }
        catch (BadInputException e) {
            return this.output.badRequest(e);
        }
        catch (PluginLookupException e) {
            return this.output.notFound(e);
        }
        catch (BadPluginInvocationException e) {
            return this.output.badRequest(e.getCause());
        }
        catch (PluginInvocationFailureException e) {
            return this.output.serverError(e.getCause());
        }
        catch (Exception e) {
            return this.output.serverError(e.getCause());
        }
    }

    @GET
    @Path(value="/{name}/node/{nodeId}/{method}")
    public Response getNodeExtensionDescription(@PathParam(value="name") String name, @PathParam(value="method") String method, @PathParam(value="nodeId") long nodeId) {
        try {
            return this.output.ok(this.describeNodeExtension(name, method));
        }
        catch (PluginLookupException e) {
            return this.output.notFound(e);
        }
        catch (Exception e) {
            return this.output.serverError(e.getCause());
        }
    }

    @POST
    @Path(value="/{name}/relationship/{relationshipId}/{method}")
    public Response invokeRelationshipExtension(@PathParam(value="name") String name, @PathParam(value="method") String method, @PathParam(value="relationshipId") long relationshipId, String data) {
        try {
            return this.output.ok(this.invokeRelationshipExtension(relationshipId, name, method, this.input.readParameterList(data)));
        }
        catch (RelationshipNotFoundException e) {
            return this.output.notFound(e);
        }
        catch (BadInputException e) {
            return this.output.badRequest(e);
        }
        catch (PluginLookupException e) {
            return this.output.notFound(e);
        }
        catch (BadPluginInvocationException e) {
            return this.output.badRequest(e.getCause());
        }
        catch (PluginInvocationFailureException e) {
            return this.output.serverError(e.getCause());
        }
        catch (Exception e) {
            return this.output.serverError(e.getCause());
        }
    }

    @GET
    @Path(value="/{name}/relationship/{relationshipId}/{method}")
    public Response getRelationshipExtensionDescription(@PathParam(value="name") String name, @PathParam(value="method") String method, @PathParam(value="relationshipId") long relationshipId) {
        try {
            return this.output.ok(this.describeRelationshipExtension(name, method));
        }
        catch (PluginLookupException e) {
            return this.output.notFound(e);
        }
        catch (Exception e) {
            return this.output.serverError(e.getCause());
        }
    }

    protected Representation extensionsList() {
        return new MappingRepresentation("extensions"){

            protected void serialize(MappingSerializer serializer) {
                for (String extension : ExtensionService.this.extensions.extensionNames()) {
                    serializer.putUri(extension, "ext/" + extension);
                }
            }
        };
    }

    protected Representation extensionList(String extensionName) throws PluginLookupException {
        return new ServerExtensionRepresentation(extensionName, this.extensions.describeAll(extensionName));
    }

    protected Representation invokeGraphDatabaseExtension(String extensionName, String method, ParameterList data) throws PluginLookupException, BadInputException, PluginInvocationFailureException, BadPluginInvocationException {
        return this.extensions.invoke(this.graphDb, extensionName, GraphDatabaseService.class, method, this.graphDb, data);
    }

    protected Representation describeGraphDatabaseExtension(String extensionName, String method) throws PluginLookupException {
        return this.extensions.describe(extensionName, GraphDatabaseService.class, method);
    }

    protected Representation invokeNodeExtension(long nodeId, String extensionName, String method, ParameterList data) throws NodeNotFoundException, PluginLookupException, BadInputException, PluginInvocationFailureException, BadPluginInvocationException {
        return this.extensions.invoke(this.graphDb, extensionName, Node.class, method, this.node(nodeId), data);
    }

    protected Representation describeNodeExtension(String extensionName, String method) throws PluginLookupException {
        return this.extensions.describe(extensionName, Node.class, method);
    }

    protected Representation invokeRelationshipExtension(long relationshipId, String extensionName, String method, ParameterList data) throws RelationshipNotFoundException, PluginLookupException, BadInputException, PluginInvocationFailureException, BadPluginInvocationException {
        return this.extensions.invoke(this.graphDb, extensionName, Relationship.class, method, this.relationship(relationshipId), data);
    }

    protected Representation describeRelationshipExtension(String extensionName, String method) throws PluginLookupException {
        return this.extensions.describe(extensionName, Relationship.class, method);
    }
}

