/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;

public class PropertyWriter {
    private PropertyStore propertyStore;

    public PropertyWriter(PropertyStore propertyStore) {
        this.propertyStore = propertyStore;
    }

    public long writeProperties(List<Pair<Integer, Object>> properties) {
        if (properties == null || properties.isEmpty()) {
            return Record.NO_NEXT_PROPERTY.intValue();
        }
        ArrayList<PropertyRecord> propRecords = new ArrayList<PropertyRecord>();
        PropertyRecord currentRecord = new PropertyRecord(this.propertyStore.nextId());
        currentRecord.setInUse(true);
        currentRecord.setCreated();
        propRecords.add(currentRecord);
        for (Pair<Integer, Object> propertyDatum : properties) {
            PropertyBlock block = new PropertyBlock();
            this.propertyStore.encodeValue(block, propertyDatum.first(), propertyDatum.other());
            if (currentRecord.size() + block.getSize() > PropertyType.getPayloadSize()) {
                PropertyRecord prevRecord = currentRecord;
                long propertyId = this.propertyStore.nextId();
                currentRecord = new PropertyRecord(propertyId);
                currentRecord.setInUse(true);
                currentRecord.setCreated();
                prevRecord.setNextProp(propertyId);
                currentRecord.setPrevProp(prevRecord.getId());
                propRecords.add(currentRecord);
            }
            currentRecord.addPropertyBlock(block);
        }
        for (int i = propRecords.size() - 1; i >= 0; --i) {
            this.propertyStore.updateRecord((PropertyRecord)propRecords.get(i));
        }
        return ((PropertyRecord)propRecords.get(0)).getId();
    }
}

