/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.guard;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.server.guard.GuardException;
import org.neo4j.server.guard.GuardingRequestFilter;

public class Guard {
    private static int totalOpsCount = 0;
    private static final Log LOG = LogFactory.getLog(GuardingRequestFilter.class);
    private final ThreadLocal<GuardInternal> threadLocal = new ThreadLocal();
    private final Timer timer = new Timer();
    private int timeLimit;

    public Guard(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void check() {
        GuardInternal guardInternal = this.threadLocal.get();
        if (guardInternal != null) {
            guardInternal.check();
        }
    }

    public void start(long valid) {
        this.threadLocal.set(new GuardInternal(valid));
    }

    public void stop() {
        GuardInternal guardInternal = this.threadLocal.get();
        if (guardInternal != null) {
            guardInternal.stop();
            this.clear();
        }
    }

    public void clear() {
        this.threadLocal.remove();
    }

    private class GuardInternal {
        private final long valid;
        private final Thread current = Thread.currentThread();
        private int opsCount = 0;
        private final TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                LOG.warn((Object)"request canceld");
                LOG.error((Object)"TODO: restarting the server is not proper implemented, request was not canceled");
            }
        };

        private GuardInternal(long valid) {
            Guard.this.timer.schedule(this.timerTask, valid + 2000L);
            this.valid = valid;
        }

        private void check() {
            totalOpsCount++;
            ++this.opsCount;
            if (this.valid < System.currentTimeMillis()) {
                long overtime = System.currentTimeMillis() - this.valid;
                LOG.error((Object)("timeout! " + overtime));
                throw new GuardException(this.opsCount, totalOpsCount, overtime);
            }
        }

        public void stop() {
            this.timerTask.cancel();
        }
    }
}

