/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.configuration.Configuration;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.server.NeoServer;
import org.neo4j.server.plugins.Injectable;
import org.neo4j.server.plugins.PluginLifecycle;
import org.neo4j.server.plugins.SPIPluginLifecycle;

public class PluginInitializer {
    private final Iterable<PluginLifecycle> pluginLifecycles;
    private final NeoServer neoServer;

    public PluginInitializer(NeoServer neoServer) {
        this.neoServer = neoServer;
        this.pluginLifecycles = Service.load(PluginLifecycle.class);
    }

    public Collection<Injectable<?>> initializePackages(Iterable<String> packageNames) {
        AbstractGraphDatabase graphDatabaseService = this.neoServer.getDatabase().graph;
        Configuration configuration = this.neoServer.getConfiguration();
        HashSet injectables = new HashSet();
        for (PluginLifecycle pluginLifecycle : this.pluginLifecycles) {
            if (!this.hasPackage(pluginLifecycle, packageNames)) continue;
            if (pluginLifecycle instanceof SPIPluginLifecycle) {
                SPIPluginLifecycle lifecycle = (SPIPluginLifecycle)pluginLifecycle;
                injectables.addAll(lifecycle.start(this.neoServer));
                continue;
            }
            injectables.addAll(pluginLifecycle.start((GraphDatabaseService)graphDatabaseService, configuration));
        }
        return injectables;
    }

    private boolean hasPackage(PluginLifecycle pluginLifecycle, Iterable<String> packageNames) {
        String lifecyclePackageName = pluginLifecycle.getClass().getPackage().getName();
        for (String packageName : packageNames) {
            if (!lifecyclePackageName.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    public void stop() {
        for (PluginLifecycle pluginLifecycle : this.pluginLifecycles) {
            pluginLifecycle.stop();
        }
    }
}

