/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.net.URISyntaxException;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.JAXRSHelper;
import org.neo4j.server.NeoServerWithEmbeddedWebServer;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.plugins.PluginManager;

public class RESTApiModule
implements ServerModule {
    private static final Logger log = Logger.getLogger(RESTApiModule.class);
    private PluginManager plugins;

    @Override
    public void start(NeoServerWithEmbeddedWebServer neoServer, StringLogger logger) {
        try {
            URI restApiUri = this.restApiUri(neoServer);
            neoServer.getWebServer().addJAXRSPackages(JAXRSHelper.listFrom(new String[]{"org.neo4j.server.rest.web"}), restApiUri.toString());
            this.loadPlugins(neoServer, logger);
            log.info("Mounted REST API at [%s]", restApiUri.toString());
            if (logger != null) {
                logger.logMessage("Mounted REST API at: " + restApiUri.toString());
            }
        }
        catch (URISyntaxException e) {
            log.warn(e);
        }
    }

    @Override
    public void stop() {
    }

    private URI restApiUri(NeoServerWithEmbeddedWebServer neoServer) throws URISyntaxException {
        return new URI(neoServer.getConfiguration().getString("org.neo4j.server.webadmin.data.uri", "/db/data"));
    }

    private void loadPlugins(NeoServerWithEmbeddedWebServer neoServer, StringLogger logger) {
        this.plugins = new PluginManager(neoServer.getConfiguration(), logger);
    }

    public PluginManager getPlugins() {
        return this.plugins;
    }
}

