/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.JAXRSHelper;
import org.neo4j.server.NeoServerWithEmbeddedWebServer;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.modules.ServerModule;

public class ThirdPartyJAXRSModule
implements ServerModule {
    private final Logger log = Logger.getLogger(ThirdPartyJAXRSModule.class);

    @Override
    public void start(NeoServerWithEmbeddedWebServer neoServer, StringLogger logger) {
        for (ThirdPartyJaxRsPackage tpp : neoServer.getConfigurator().getThirdpartyJaxRsClasses()) {
            neoServer.getWebServer().addJAXRSPackages(JAXRSHelper.listFrom(new String[]{tpp.getPackageName()}), tpp.getMountPoint());
            this.log.info("Mounted third-party JAX-RS package [%s] at [%s]", tpp.getPackageName(), tpp.getMountPoint());
            if (logger == null) continue;
            logger.logMessage(String.format("Mounted third-party JAX-RS package [%s] at [%s]", tpp.getPackageName(), tpp.getMountPoint()));
        }
    }

    @Override
    public void stop() {
    }
}

