/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.console;

import org.neo4j.cypher.SyntaxException;
import org.neo4j.cypher.commands.Query;
import org.neo4j.cypher.javacompat.CypherParser;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.Pair;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.webadmin.console.ScriptSession;

public class CypherSession
implements ScriptSession {
    private final ExecutionEngine engine;
    private static Logger log = Logger.getLogger(CypherSession.class);

    public CypherSession(GraphDatabaseService graph) {
        this.engine = new ExecutionEngine(graph);
    }

    @Override
    public Pair<String, String> evaluate(String script) {
        if (script.trim().equals("")) {
            return Pair.of((Object)"", null);
        }
        String resultString = null;
        try {
            Query query = CypherParser.parseConsole((String)script);
            ExecutionResult result = this.engine.execute(query);
            resultString = result.toString();
        }
        catch (SyntaxException error) {
            resultString = error.getMessage();
        }
        catch (Exception exception) {
            log.error(exception);
            resultString = "Error: " + exception.getClass().getSimpleName() + " - " + exception.getMessage();
        }
        return Pair.of((Object)resultString, null);
    }
}

