/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import java.rmi.RemoteException;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.KernelExtension;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.webadmin.console.ScriptSession;
import org.neo4j.shell.Output;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.impl.AbstractClient;
import org.neo4j.shell.impl.CollectingOutput;
import org.neo4j.shell.impl.SameJvmClient;
import org.neo4j.shell.impl.ShellServerExtension;

public class ShellSession
implements ScriptSession {
    public static final Logger log = Logger.getLogger(ShellSession.class);
    private final ShellClient client;
    private final CollectingOutput output;

    public ShellSession(AbstractGraphDatabase graph) {
        ShellServerExtension shell = (ShellServerExtension)Service.load(KernelExtension.class, (String)"shell");
        if (shell == null) {
            throw new UnsupportedOperationException("Shell server not found");
        }
        ShellServer server = shell.getShellServer(graph.getKernelData());
        if (server == null) {
            throw new IllegalStateException("Shell server null");
        }
        try {
            this.output = new CollectingOutput();
            this.client = new SameJvmClient(server, (Output)this.output);
            this.output.asString();
        }
        catch (RemoteException e) {
            throw new RuntimeException("Unable to start shell client", e);
        }
    }

    @Override
    public Pair<String, String> evaluate(String script) {
        if (script.equals("init()")) {
            return Pair.of((Object)"", (Object)this.client.getPrompt());
        }
        if (script.equals("exit") || script.equals("quit")) {
            return Pair.of((Object)"No you don't", (Object)this.client.getPrompt());
        }
        try {
            log.debug(script, new Object[0]);
            this.client.evaluate(this.removeFirstEnter(script));
            return Pair.of((Object)this.output.asString(), (Object)this.client.getPrompt());
        }
        catch (ShellException e) {
            String message = ((AbstractClient)this.client).shouldPrintStackTraces() ? ShellException.stackTraceAsString((Throwable)e) : ShellException.getFirstMessage((Throwable)e);
            return Pair.of((Object)message, (Object)this.client.getPrompt());
        }
    }

    private String removeFirstEnter(String script) {
        return script != null && script.startsWith("\n") ? script.substring(1) : script;
    }
}

