/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.IOException;
import java.util.Set;
import org.geotools.data.AbstractFeatureSource;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureListener;
import org.geotools.data.Query;
import org.geotools.data.ResourceInfo;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;

class ShapefileFeatureSource
extends AbstractFeatureSource {
    private final ShapefileDataStore shapefile;
    private final SimpleFeatureType featureType;

    ShapefileFeatureSource(ShapefileDataStore shapefileDataStore, Set hints, SimpleFeatureType featureType) {
        super(hints);
        this.shapefile = shapefileDataStore;
        this.featureType = featureType;
    }

    @Override
    public DataStore getDataStore() {
        return this.shapefile;
    }

    @Override
    public void addFeatureListener(FeatureListener listener) {
        this.shapefile.listenerManager.addFeatureListener(this, listener);
    }

    @Override
    public void removeFeatureListener(FeatureListener listener) {
        this.shapefile.listenerManager.removeFeatureListener(this, listener);
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.featureType;
    }

    @Override
    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return this.shapefile.getBounds(query);
    }

    @Override
    public ResourceInfo getInfo() {
        return this.shapefile.getInfo(this.featureType.getTypeName());
    }
}

