/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.neo4j;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.BasicFeatureTypes;
import org.geotools.resources.Classes;
import org.neo4j.gis.spatial.Layer;
import org.neo4j.gis.spatial.SpatialDatabaseService;
import org.neo4j.gis.spatial.SpatialRecord;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Neo4jFeatureBuilder {
    private static final String FEATURE_PROP_GEOM = "the_geom";
    private final SimpleFeatureBuilder builder;
    private final List<String> extraPropertyNames;

    public Neo4jFeatureBuilder(SimpleFeatureType sft, List<String> extraPropertyNames) {
        this.builder = new SimpleFeatureBuilder(sft);
        this.extraPropertyNames = extraPropertyNames;
    }

    public Neo4jFeatureBuilder(Layer layer) {
        this(Neo4jFeatureBuilder.getTypeFromLayer(layer), Arrays.asList(layer.getExtraPropertyNames()));
    }

    public SimpleFeature buildFeature(String id, Geometry geometry, Map<String, Object> properties) {
        this.builder.reset();
        this.builder.set(FEATURE_PROP_GEOM, (Object)geometry);
        if (this.extraPropertyNames != null) {
            for (String name : this.extraPropertyNames) {
                this.builder.set(name, properties.get(name));
            }
        }
        return this.builder.buildFeature(id);
    }

    public SimpleFeature buildFeature(SpatialRecord rec) {
        return this.buildFeature(rec.getId(), rec.getGeometry(), rec.getProperties());
    }

    public static SimpleFeatureType getTypeFromLayer(Layer layer) {
        return Neo4jFeatureBuilder.getType(layer.getName(), layer.getGeometryType(), layer.getCoordinateReferenceSystem(), layer.getExtraPropertyNames());
    }

    public static SimpleFeatureType getType(String name, Integer geometryTypeId, CoordinateReferenceSystem crs, String[] extraPropertyNames) {
        List<AttributeDescriptor> types = Neo4jFeatureBuilder.readAttributes(geometryTypeId, crs, extraPropertyNames);
        SimpleFeatureType parent = null;
        GeometryDescriptor geomDescriptor = (GeometryDescriptor)types.get(0);
        Class geomBinding = geomDescriptor.getType().getBinding();
        if (geomBinding == Point.class || geomBinding == MultiPoint.class) {
            parent = BasicFeatureTypes.POINT;
        } else if (geomBinding == Polygon.class || geomBinding == MultiPolygon.class) {
            parent = BasicFeatureTypes.POLYGON;
        } else if (geomBinding == LineString.class || geomBinding == MultiLineString.class || geomBinding == LinearRing.class) {
            parent = BasicFeatureTypes.LINE;
        }
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setDefaultGeometry(geomDescriptor.getLocalName());
        builder.addAll(types);
        builder.setName(name);
        builder.setNamespaceURI("http://www.opengis.net/gml");
        builder.setAbstract(false);
        builder.setCRS(crs);
        if (parent != null) {
            builder.setSuperType(parent);
        }
        return builder.buildFeatureType();
    }

    private static List<AttributeDescriptor> readAttributes(Integer geometryTypeId, CoordinateReferenceSystem crs, String[] extraPropertyNames) {
        Class<? extends Geometry> geometryClass = SpatialDatabaseService.convertGeometryTypeToJtsClass(geometryTypeId);
        AttributeTypeBuilder build = new AttributeTypeBuilder();
        build.setName(Classes.getShortName(geometryClass));
        build.setNillable(true);
        build.setCRS(crs);
        build.setBinding(geometryClass);
        GeometryType geometryType = build.buildGeometryType();
        ArrayList<AttributeDescriptor> attributes = new ArrayList<AttributeDescriptor>();
        attributes.add((AttributeDescriptor)build.buildDescriptor(FEATURE_PROP_GEOM, geometryType));
        if (extraPropertyNames != null) {
            HashSet<String> usedNames = new HashSet<String>();
            usedNames.add(FEATURE_PROP_GEOM);
            for (String propertyName : extraPropertyNames) {
                if (usedNames.contains(propertyName)) continue;
                usedNames.add(propertyName);
                build.setNillable(true);
                build.setBinding(String.class);
                attributes.add(build.buildDescriptor(propertyName));
            }
        }
        return attributes;
    }
}

