/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.neo4j;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.geotools.data.AbstractDataStoreFactory;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.neo4j.Neo4jSpatialDataStore;
import org.geotools.util.KVP;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.EmbeddedGraphDatabase;

public class Neo4jSpatialDataStoreFactory
extends AbstractDataStoreFactory
implements DataStoreFactorySpi {
    public static final DataAccessFactory.Param DIRECTORY = new DataAccessFactory.Param("The directory path of the Neo4j database: ", File.class, "db", true);
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "must be 'neo4j'", true, (Object)"neo4j", (Map)new KVP(new Object[]{"level", "program"}));

    public boolean canProcess(Map params) {
        String type = (String)params.get("dbtype");
        if (type != null) {
            return type.equalsIgnoreCase("neo4j");
        }
        return false;
    }

    public DataStore createDataStore(Map params) throws IOException {
        if (!this.canProcess(params)) {
            throw new IOException("The parameters map isn't correct!!");
        }
        File neodir = (File)DIRECTORY.lookUp(params);
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(neodir.getAbsolutePath());
        Neo4jSpatialDataStore dataStore = new Neo4jSpatialDataStore((GraphDatabaseService)db);
        return dataStore;
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException("Neo4j Spatial cannot create a new database!");
    }

    public String getDisplayName() {
        return "Neo4j";
    }

    public String getDescription() {
        return "A datasource backed by a Neo4j Spatial datasource";
    }

    public boolean isAvailable() {
        return true;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{DBTYPE, DIRECTORY};
    }
}

