/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.neo4j;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.neo4j.gis.spatial.Layer;
import org.neo4j.gis.spatial.SpatialDatabaseRecord;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class Neo4jSpatialFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private static final Logger log = Logger.getLogger((String)Neo4jSpatialFeatureReader.class.getName());
    protected static final String FEATURE_PROP_GEOM = "the_geom";
    private Layer layer;
    private SimpleFeatureType featureType;
    private SimpleFeatureBuilder builder;
    private Iterator<SpatialDatabaseRecord> results;
    private String[] extraPropertyNames;

    public Neo4jSpatialFeatureReader(Layer layer, SimpleFeatureType featureType, Iterator<SpatialDatabaseRecord> results) {
        this.layer = layer;
        this.extraPropertyNames = layer.getExtraPropertyNames();
        this.featureType = featureType;
        this.builder = new SimpleFeatureBuilder(featureType);
        this.results = results;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public boolean hasNext() throws IOException {
        return this.results != null && this.results.hasNext();
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        if (this.results == null) {
            return null;
        }
        SpatialDatabaseRecord record = this.results.next();
        if (record == null) {
            return null;
        }
        this.builder.reset();
        this.builder.set(FEATURE_PROP_GEOM, (Object)record.getGeometry());
        if (this.extraPropertyNames != null) {
            for (int i = 0; i < this.extraPropertyNames.length; ++i) {
                if (!record.hasProperty(this.extraPropertyNames[i])) continue;
                this.builder.set(this.extraPropertyNames[i], record.getProperty(this.extraPropertyNames[i]));
            }
        }
        return this.builder.buildFeature(record.getId());
    }

    public void close() throws IOException {
        log.debug((Object)"");
        this.featureType = null;
        this.builder = null;
        this.results = null;
    }

    protected Layer getLayer() {
        return this.layer;
    }
}

