/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.neo4j;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.logging.Logger;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.neo4j.gis.spatial.EditableLayer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class Neo4jSpatialFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    private SimpleFeature live;
    private SimpleFeature current;
    private FeatureListenerManager listener;
    private Transaction transaction;
    private SimpleFeatureType featureType;
    private FeatureReader<SimpleFeatureType, SimpleFeature> reader;
    private EditableLayer layer;
    private boolean closed;
    private static final Logger LOGGER = Logging.getLogger((String)"org.neo4j.gis.spatial");

    protected Neo4jSpatialFeatureWriter(FeatureListenerManager listener, Transaction transaction, EditableLayer layer, FeatureReader<SimpleFeatureType, SimpleFeature> reader) {
        this.transaction = transaction;
        this.listener = listener;
        this.reader = reader;
        this.layer = layer;
        this.featureType = (SimpleFeatureType)reader.getFeatureType();
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public boolean hasNext() throws IOException {
        if (this.closed) {
            throw new IOException("Feature writer is closed");
        }
        return this.reader != null && this.reader.hasNext();
    }

    public SimpleFeature next() throws IOException {
        if (this.closed) {
            throw new IOException("FeatureWriter has been closed");
        }
        SimpleFeatureType featureType = this.getFeatureType();
        if (this.hasNext()) {
            this.live = (SimpleFeature)this.reader.next();
            this.current = SimpleFeatureBuilder.copy((SimpleFeature)this.live);
            LOGGER.finer("Calling next on writer");
        } else {
            this.live = null;
            this.current = SimpleFeatureBuilder.template((SimpleFeatureType)featureType, null);
        }
        return this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() throws IOException {
        if (this.closed) {
            throw new IOException("FeatureWriter has been closed");
        }
        if (this.current == null) {
            throw new IOException("No feature available to remove");
        }
        if (this.live != null) {
            LOGGER.fine("Removing " + this.live);
            org.neo4j.graphdb.Transaction tx = this.layer.getSpatialDatabase().getDatabase().beginTx();
            try {
                this.layer.delete(Long.parseLong(this.live.getID()));
                tx.success();
            }
            finally {
                tx.finish();
            }
            this.listener.fireFeaturesRemoved(this.featureType.getTypeName(), this.transaction, new ReferencedEnvelope(this.live.getBounds()), true);
        }
        this.live = null;
        this.current = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        if (this.closed) {
            throw new IOException("FeatureWriter has been closed");
        }
        if (this.current == null) {
            throw new IOException("No feature available to write");
        }
        LOGGER.fine("Write called, live is " + this.live + " and cur is " + this.current);
        if (this.live != null) {
            if (!this.live.equals(this.current)) {
                LOGGER.fine("Updating " + this.current);
                org.neo4j.graphdb.Transaction tx = this.layer.getSpatialDatabase().getDatabase().beginTx();
                try {
                    this.layer.update(Long.parseLong(this.current.getID()), (Geometry)this.current.getDefaultGeometry());
                    tx.success();
                }
                finally {
                    tx.finish();
                }
                this.listener.fireFeaturesChanged(this.featureType.getTypeName(), this.transaction, new ReferencedEnvelope(this.current.getBounds()), true);
            }
        } else {
            LOGGER.fine("Inserting " + this.current);
            org.neo4j.graphdb.Transaction tx = this.layer.getSpatialDatabase().getDatabase().beginTx();
            try {
                this.layer.add((Geometry)this.current.getDefaultGeometry());
                tx.success();
            }
            finally {
                tx.finish();
            }
            this.listener.fireFeaturesAdded(this.featureType.getTypeName(), this.transaction, new ReferencedEnvelope(this.current.getBounds()), true);
        }
        this.live = null;
        this.current = null;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        this.closed = true;
    }
}

