/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.neo4j;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.data.neo4j.Neo4jSpatialDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.neo4j.gis.spatial.SpatialTopologyUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Fill;

public class StyledImageExporter {
    private GraphDatabaseService db;
    private File exportDir;
    double zoom = 1.0;
    double[] offset = new double[]{0.0, 0.0};
    Rectangle displaySize = new Rectangle(400, 300);
    private String[] styleFiles;
    static StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
    static FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);

    public StyledImageExporter(GraphDatabaseService db) {
        this.db = db;
    }

    public void setExportDir(String dir) {
        this.exportDir = dir == null || dir.length() == 0 ? null : new File(dir).getAbsoluteFile();
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public void setSize(int width, int height) {
        this.displaySize = new Rectangle(width, height);
    }

    public void setStyleFiles(String[] files) {
        this.styleFiles = files;
    }

    public Style getStyle(int i) {
        if (this.styleFiles != null && i < this.styleFiles.length) {
            return this.getStyleFromSLDFile(this.styleFiles[i]);
        }
        return null;
    }

    public void setOffset(double fractionWidth, double fractionHeight) {
        this.offset[0] = fractionWidth;
        this.offset[1] = fractionHeight;
    }

    private File checkFile(File file) {
        if (!file.isAbsolute() && this.exportDir != null) {
            file = new File(this.exportDir, file.getPath());
        }
        file = file.getAbsoluteFile();
        file.getParentFile().mkdirs();
        if (file.exists()) {
            System.out.println("Deleting previous file: " + file);
            file.delete();
        }
        return file;
    }

    private void debugStore(DataStore store, String[] layerNames) throws IOException {
        for (int i = 0; i < layerNames.length; ++i) {
            System.out.println(Arrays.asList(store.getTypeNames()));
            System.out.println(Arrays.asList(store.getSchema(layerNames[i]).getAttributeDescriptors()));
        }
    }

    public void saveLayerImage(String[] layerNames) throws IOException {
        this.saveLayerImage(layerNames, null, new File(layerNames[0] + ".png"), null);
    }

    public void saveLayerImage(String[] layerNames, File imageFile) throws IOException {
        this.saveLayerImage(layerNames, null, imageFile, null);
    }

    public void saveLayerImage(String layerName) throws IOException {
        this.saveLayerImage(layerName, null, new File(layerName + ".png"), null);
    }

    public void saveLayerImage(String layerName, String sldFile) throws IOException {
        this.saveLayerImage(layerName, sldFile, new File(layerName + ".png"), null);
    }

    public void saveLayerImage(String layerName, String sldFile, String imageFile) throws IOException {
        this.saveLayerImage(layerName, sldFile, new File(imageFile), null);
    }

    public void saveLayerImage(String layerName, String sldFile, File imagefile, ReferencedEnvelope bounds, int width, int height, double zoom) throws IOException {
        this.setZoom(zoom);
        this.setSize(width, height);
        this.saveLayerImage(layerName, sldFile, imagefile, bounds);
    }

    public void saveLayerImage(String layerName, String sldFile, File imagefile, ReferencedEnvelope bounds) throws IOException {
        String[] layerNames = new String[]{layerName};
        this.saveLayerImage(layerNames, sldFile, imagefile, bounds);
    }

    public void saveImage(FeatureCollection<SimpleFeatureType, SimpleFeature> features, String sldFile, File imagefile) throws IOException {
        this.saveImage(features, this.getStyleFromSLDFile(sldFile), imagefile);
    }

    public void saveImage(FeatureCollection<SimpleFeatureType, SimpleFeature> features, Style style, File imagefile) throws IOException {
        MapContent mapContent = new MapContent();
        mapContent.addLayer((Layer)new FeatureLayer(features, style));
        this.saveMapContentToImageFile(mapContent, imagefile, features.getBounds());
    }

    public void saveImage(FeatureCollection<SimpleFeatureType, SimpleFeature>[] features, Style[] styles, File imagefile, ReferencedEnvelope bounds) throws IOException {
        MapContent mapContent = new MapContent();
        for (int i = 0; i < features.length; ++i) {
            mapContent.addLayer((Layer)new FeatureLayer(features[i], styles[i]));
        }
        this.saveMapContentToImageFile(mapContent, imagefile, bounds);
    }

    public void saveLayerImage(String[] layerNames, String sldFile, File imagefile, ReferencedEnvelope bounds) throws IOException {
        Neo4jSpatialDataStore store = new Neo4jSpatialDataStore(this.db);
        StringBuffer names = new StringBuffer();
        for (String name : layerNames) {
            if (names.length() > 0) {
                names.append(", ");
            }
            names.append(name);
        }
        System.out.println("Exporting layers '" + names + "' to styled image " + imagefile.getPath());
        Style style = this.getStyleFromSLDFile(sldFile);
        MapContent mapContent = new MapContent();
        for (int i = 0; i < layerNames.length; ++i) {
            SimpleFeatureSource featureSource = store.getFeatureSource(layerNames[i]);
            Style featureStyle = style;
            if (featureStyle == null) {
                featureStyle = this.getStyle(i);
            }
            if (featureStyle == null) {
                featureStyle = StyledImageExporter.createStyleFromGeometry((FeatureType)((SimpleFeatureType)featureSource.getSchema()), Color.BLUE, Color.CYAN);
                System.out.println("Created style from geometry '" + ((SimpleFeatureType)featureSource.getSchema()).getGeometryDescriptor().getType() + "': " + featureStyle);
            }
            mapContent.addLayer((Layer)new FeatureLayer((FeatureSource)featureSource, featureStyle));
            if (bounds == null) {
                bounds = featureSource.getBounds();
                continue;
            }
            bounds.expandToInclude((Envelope)featureSource.getBounds());
        }
        this.saveMapContentToImageFile(mapContent, imagefile, bounds);
    }

    private Style getStyleFromSLDFile(String sldFile) {
        Style style = null;
        if (sldFile != null && (style = this.createStyleFromSLD(sldFile)) != null) {
            System.out.println("Created style from sldFile '" + sldFile + "': " + style);
        }
        return style;
    }

    private void saveMapContentToImageFile(MapContent mapContent, File imagefile, ReferencedEnvelope bounds) throws IOException {
        bounds = SpatialTopologyUtils.adjustBounds(bounds, 1.0 / this.zoom, this.offset);
        if (this.displaySize == null) {
            this.displaySize = new Rectangle(0, 0, 800, 600);
        }
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        BufferedImage image = new BufferedImage(this.displaySize.width, this.displaySize.height, 2);
        Graphics2D graphics = image.createGraphics();
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setJava2DHints(hints);
        renderer.setMapContent(mapContent);
        renderer.paint(graphics, this.displaySize, bounds);
        graphics.dispose();
        mapContent.dispose();
        ImageIO.write((RenderedImage)image, "png", this.checkFile(imagefile));
    }

    private Style createStyleFromSLD(String sldFile) {
        try {
            SLDParser stylereader = new SLDParser(styleFactory, new File(sldFile).toURI().toURL());
            Style[] style = stylereader.readXML();
            return style[0];
        }
        catch (Exception e) {
            System.err.println("Failed to read style from '" + sldFile + "': " + e.getMessage());
            return null;
        }
    }

    public static Style createDefaultStyle(Color strokeColor, Color fillColor) {
        return StyledImageExporter.createStyleFromGeometry(null, strokeColor, fillColor);
    }

    public static Style createStyleFromGeometry(FeatureType schema, Color strokeColor, Color fillColor) {
        if (schema != null) {
            Class geomType = schema.getGeometryDescriptor().getType().getBinding();
            if (Polygon.class.isAssignableFrom(geomType) || MultiPolygon.class.isAssignableFrom(geomType)) {
                return StyledImageExporter.createPolygonStyle(strokeColor, fillColor);
            }
            if (LineString.class.isAssignableFrom(geomType) || LinearRing.class.isAssignableFrom(geomType) || MultiLineString.class.isAssignableFrom(geomType)) {
                return StyledImageExporter.createLineStyle(strokeColor);
            }
            if (Point.class.isAssignableFrom(geomType) || MultiPoint.class.isAssignableFrom(geomType)) {
                return StyledImageExporter.createPointStyle(strokeColor, fillColor);
            }
        }
        Style style = styleFactory.createStyle();
        style.featureTypeStyles().addAll(StyledImageExporter.createPolygonStyle(strokeColor, fillColor).featureTypeStyles());
        style.featureTypeStyles().addAll(StyledImageExporter.createLineStyle(strokeColor).featureTypeStyles());
        style.featureTypeStyles().addAll(StyledImageExporter.createPointStyle(strokeColor, fillColor).featureTypeStyles());
        System.out.println("Created Geometry Style: " + style);
        return style;
    }

    private static Style createPolygonStyle(Color strokeColor, Color fillColor) {
        Stroke stroke = styleFactory.createStroke((Expression)filterFactory.literal((Object)strokeColor), (Expression)filterFactory.literal(1), (Expression)filterFactory.literal(0.5));
        org.geotools.styling.Fill fill = styleFactory.createFill((Expression)filterFactory.literal((Object)fillColor), (Expression)filterFactory.literal(0.5));
        PolygonSymbolizer sym = styleFactory.createPolygonSymbolizer(stroke, fill, null);
        Rule rule = styleFactory.createRule();
        rule.symbolizers().add(sym);
        try {
            rule.setFilter(ECQL.toFilter((String)"geometryType(the_geom)='Polygon' or geometryType(the_geom)='MultiPoligon'"));
        }
        catch (CQLException e) {
            e.printStackTrace();
        }
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle(new Rule[]{rule});
        Style style = styleFactory.createStyle();
        style.featureTypeStyles().add(fts);
        System.out.println("Created Polygon Style: " + style);
        return style;
    }

    private static Style createLineStyle(Color strokeColor) {
        Stroke stroke = styleFactory.createStroke((Expression)filterFactory.literal((Object)strokeColor), (Expression)filterFactory.literal(1));
        LineSymbolizer sym = styleFactory.createLineSymbolizer(stroke, null);
        Rule rule = styleFactory.createRule();
        rule.symbolizers().add(sym);
        try {
            rule.setFilter(ECQL.toFilter((String)"geometryType(the_geom)='LineString' or geometryType(the_geom)='LinearRing' or geometryType(the_geom)='MultiLineString'"));
        }
        catch (CQLException e) {
            e.printStackTrace();
        }
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle(new Rule[]{rule});
        Style style = styleFactory.createStyle();
        style.featureTypeStyles().add(fts);
        System.out.println("Created Line Style: " + style);
        return style;
    }

    private static Style createPointStyle(Color strokeColor, Color fillColor) {
        Mark mark = styleFactory.getCircleMark();
        mark.setStroke((org.opengis.style.Stroke)styleFactory.createStroke((Expression)filterFactory.literal((Object)strokeColor), (Expression)filterFactory.literal(2)));
        mark.setFill((Fill)styleFactory.createFill((Expression)filterFactory.literal((Object)fillColor)));
        Graphic gr = styleFactory.createDefaultGraphic();
        gr.graphicalSymbols().clear();
        gr.graphicalSymbols().add(mark);
        gr.setSize((Expression)filterFactory.literal(5));
        PointSymbolizer sym = styleFactory.createPointSymbolizer(gr, null);
        Rule rule = styleFactory.createRule();
        rule.symbolizers().add(sym);
        try {
            rule.setFilter(ECQL.toFilter((String)"geometryType(the_geom)='Point' or geometryType(the_geom)='MultiPoint'"));
        }
        catch (CQLException e) {
            e.printStackTrace();
        }
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle(new Rule[]{rule});
        Style style = styleFactory.createStyle();
        style.featureTypeStyles().add(fts);
        System.out.println("Created Point Style: " + style);
        return style;
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.err.println("Too few arguments. Provide: 'database' 'exportdir' 'stylefile' zoom layer <layers..>");
            return;
        }
        String database = args[0];
        String exportdir = args[1];
        String stylefile = args[2];
        double zoom = new Double(args[3]);
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(database);
        try {
            StyledImageExporter imageExporter = new StyledImageExporter((GraphDatabaseService)db);
            imageExporter.setExportDir(exportdir);
            imageExporter.setZoom(zoom);
            imageExporter.setSize(800, 600);
            for (int i = 4; i < args.length; ++i) {
                imageExporter.saveLayerImage(args[i], stylefile);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            db.shutdown();
        }
    }
}

