/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.neo4j.collections.rtree.Envelope;
import org.neo4j.collections.rtree.Listener;
import org.neo4j.collections.rtree.filter.SearchFilter;
import org.neo4j.gis.spatial.Constants;
import org.neo4j.gis.spatial.GeometryEncoder;
import org.neo4j.gis.spatial.Layer;
import org.neo4j.gis.spatial.LayerIndexReader;
import org.neo4j.gis.spatial.LayerRTreeIndex;
import org.neo4j.gis.spatial.SpatialDatabaseException;
import org.neo4j.gis.spatial.SpatialDatabaseRecord;
import org.neo4j.gis.spatial.SpatialDatabaseService;
import org.neo4j.gis.spatial.SpatialDataset;
import org.neo4j.gis.spatial.SpatialRelationshipTypes;
import org.neo4j.gis.spatial.WKBGeometryEncoder;
import org.neo4j.gis.spatial.attributes.PropertyMappingManager;
import org.neo4j.gis.spatial.encoders.Configurable;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.Traverser;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DefaultLayer
implements Constants,
Layer,
SpatialDataset {
    private SpatialDatabaseService spatialDatabase;
    private String name;
    protected Node layerNode;
    protected GeometryEncoder geometryEncoder;
    protected GeometryFactory geometryFactory;
    protected LayerRTreeIndex index;
    private PropertyMappingManager propertyMappingManager;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SpatialDatabaseService getSpatialDatabase() {
        return this.spatialDatabase;
    }

    @Override
    public LayerIndexReader getIndex() {
        return this.index;
    }

    @Override
    public SpatialDatabaseRecord add(Node geomNode) {
        Geometry geometry = this.getGeometryEncoder().decodeGeometry((PropertyContainer)geomNode);
        this.getGeometryEncoder().encodeGeometry(geometry, (PropertyContainer)geomNode);
        this.index.add(geomNode);
        return new SpatialDatabaseRecord(this, geomNode, geometry);
    }

    @Override
    public GeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        Node layerNode = this.getLayerNode();
        layerNode.setProperty("layercrs", (Object)crs.toWKT());
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        Node layerNode = this.getLayerNode();
        if (layerNode.hasProperty("layercrs")) {
            try {
                return ReferencingFactoryFinder.getCRSFactory(null).createFromWKT((String)layerNode.getProperty("layercrs"));
            }
            catch (FactoryRegistryException e) {
                throw new SpatialDatabaseException(e);
            }
            catch (FactoryException e) {
                throw new SpatialDatabaseException(e);
            }
        }
        return null;
    }

    public void setGeometryType(Integer geometryType) {
        Node layerNode = this.getLayerNode();
        if (geometryType != null) {
            if (geometryType < 1 || geometryType > 6) {
                throw new IllegalArgumentException("Unknown geometry type: " + geometryType);
            }
            layerNode.setProperty("gtype", (Object)geometryType);
        } else {
            layerNode.removeProperty("gtype");
        }
    }

    @Override
    public Integer getGeometryType() {
        Node layerNode = this.getLayerNode();
        if (layerNode.hasProperty("gtype")) {
            return (Integer)layerNode.getProperty("gtype");
        }
        GuessGeometryTypeSearch geomTypeSearch = new GuessGeometryTypeSearch();
        this.index.searchIndex(geomTypeSearch).count();
        if (geomTypeSearch.firstFoundType != null) {
            return geomTypeSearch.firstFoundType;
        }
        return null;
    }

    @Override
    public String[] getExtraPropertyNames() {
        Node layerNode = this.getLayerNode();
        if (layerNode.hasProperty("layerprops")) {
            return (String[])layerNode.getProperty("layerprops");
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtraPropertyNames(String[] names) {
        Transaction tx = this.getDatabase().beginTx();
        try {
            this.getLayerNode().setProperty("layerprops", (Object)names);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public void mergeExtraPropertyNames(String[] names) {
        Node layerNode = this.getLayerNode();
        if (layerNode.hasProperty("layerprops")) {
            String[] actualNames = (String[])layerNode.getProperty("layerprops");
            HashSet<String> mergedNames = new HashSet<String>();
            for (String name : names) {
                mergedNames.add(name);
            }
            for (String name : actualNames) {
                mergedNames.add(name);
            }
            layerNode.setProperty("layerprops", (Object)mergedNames.toArray(new String[mergedNames.size()]));
        } else {
            layerNode.setProperty("layerprops", (Object)names);
        }
    }

    protected DefaultLayer() {
    }

    protected static Layer makeLayerFromNode(SpatialDatabaseService spatialDatabase, Node layerNode) {
        try {
            String name = (String)layerNode.getProperty("layer");
            if (name == null) {
                return null;
            }
            String className = null;
            if (layerNode.hasProperty("layer_class")) {
                className = (String)layerNode.getProperty("layer_class");
            }
            Class layerClass = className == null ? Layer.class : Class.forName(className);
            return DefaultLayer.makeLayerInstance(spatialDatabase, name, layerNode, layerClass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static Layer makeLayerAndNode(SpatialDatabaseService spatialDatabase, String name, Class<? extends GeometryEncoder> geometryEncoderClass, Class<? extends Layer> layerClass) {
        try {
            Node layerNode = spatialDatabase.getDatabase().createNode();
            layerNode.setProperty("layer", (Object)name);
            layerNode.setProperty("ctime", (Object)System.currentTimeMillis());
            layerNode.setProperty("geomencoder", (Object)geometryEncoderClass.getCanonicalName());
            layerNode.setProperty("layer_class", (Object)layerClass.getCanonicalName());
            return DefaultLayer.makeLayerInstance(spatialDatabase, name, layerNode, layerClass);
        }
        catch (Exception e) {
            throw new SpatialDatabaseException(e);
        }
    }

    private static Layer makeLayerInstance(SpatialDatabaseService spatialDatabase, String name, Node layerNode, Class<? extends Layer> layerClass) throws InstantiationException, IllegalAccessException {
        if (layerClass == null) {
            layerClass = Layer.class;
        }
        Layer layer = layerClass.newInstance();
        layer.initialize(spatialDatabase, name, layerNode);
        return layer;
    }

    @Override
    public void initialize(SpatialDatabaseService spatialDatabase, String name, Node layerNode) {
        this.spatialDatabase = spatialDatabase;
        this.name = name;
        this.layerNode = layerNode;
        this.geometryFactory = new GeometryFactory();
        if (layerNode.hasProperty("geomencoder")) {
            String encoderClassName = (String)layerNode.getProperty("geomencoder");
            try {
                this.geometryEncoder = (GeometryEncoder)Class.forName(encoderClassName).newInstance();
            }
            catch (Exception e) {
                throw new SpatialDatabaseException(e);
            }
            if (this.geometryEncoder instanceof Configurable && layerNode.hasProperty("geomencoder_config")) {
                ((Configurable)((Object)this.geometryEncoder)).setConfiguration((String)layerNode.getProperty("geomencoder_config"));
            }
        } else {
            this.geometryEncoder = new WKBGeometryEncoder();
        }
        this.geometryEncoder.init(this);
        this.index = new LayerRTreeIndex(spatialDatabase.getDatabase(), this);
    }

    @Override
    public Node getLayerNode() {
        return this.layerNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Listener monitor) {
        this.index.removeAll(true, monitor);
        Transaction tx = this.getDatabase().beginTx();
        try {
            Node layerNode = this.getLayerNode();
            layerNode.getSingleRelationship((RelationshipType)SpatialRelationshipTypes.LAYER, Direction.INCOMING).delete();
            layerNode.delete();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    protected GraphDatabaseService getDatabase() {
        return this.spatialDatabase.getDatabase();
    }

    @Override
    public SpatialDataset getDataset() {
        return this;
    }

    @Override
    public Iterable<Node> getAllGeometryNodes() {
        return this.layerNode.traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, ReturnableEvaluator.ALL_BUT_START_NODE, (RelationshipType)SpatialRelationshipTypes.GEOMETRIES, Direction.OUTGOING, (RelationshipType)SpatialRelationshipTypes.NEXT_GEOM, Direction.OUTGOING);
    }

    @Override
    public Iterable<? extends Geometry> getAllGeometries() {
        return new NodeToGeometryIterable(this.getAllGeometryNodes());
    }

    @Override
    public GeometryEncoder getGeometryEncoder() {
        return this.geometryEncoder;
    }

    @Override
    public Iterable<? extends Layer> getLayers() {
        return Arrays.asList(this);
    }

    @Override
    public Object getStyle() {
        return null;
    }

    @Override
    public PropertyMappingManager getPropertyMappingManager() {
        if (this.propertyMappingManager == null) {
            this.propertyMappingManager = new PropertyMappingManager(this);
        }
        return this.propertyMappingManager;
    }

    private class NodeToGeometryIterable
    implements Iterable<Geometry> {
        private Iterator<Node> allGeometryNodeIterator;

        public NodeToGeometryIterable(Iterable<Node> allGeometryNodes) {
            this.allGeometryNodeIterator = allGeometryNodes.iterator();
        }

        @Override
        public Iterator<Geometry> iterator() {
            return new GeometryIterator();
        }

        private class GeometryIterator
        implements Iterator<Geometry> {
            private GeometryIterator() {
            }

            @Override
            public boolean hasNext() {
                return NodeToGeometryIterable.this.allGeometryNodeIterator.hasNext();
            }

            @Override
            public Geometry next() {
                return DefaultLayer.this.geometryEncoder.decodeGeometry((PropertyContainer)NodeToGeometryIterable.this.allGeometryNodeIterator.next());
            }

            @Override
            public void remove() {
            }
        }
    }

    private static class GuessGeometryTypeSearch
    implements SearchFilter {
        Integer firstFoundType;

        private GuessGeometryTypeSearch() {
        }

        public boolean needsToVisit(Envelope indexNodeEnvelope) {
            return this.firstFoundType == null;
        }

        public boolean geometryMatches(Node geomNode) {
            if (this.firstFoundType == null) {
                this.firstFoundType = (Integer)geomNode.getProperty("gtype");
            }
            return false;
        }
    }
}

