/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.neo4j.collections.rtree.EnvelopeDecoder;
import org.neo4j.collections.rtree.RTreeIndex;
import org.neo4j.collections.rtree.filter.SearchFilter;
import org.neo4j.gis.spatial.Constants;
import org.neo4j.gis.spatial.Layer;
import org.neo4j.gis.spatial.LayerTreeIndexReader;
import org.neo4j.gis.spatial.SpatialDatabaseRecord;
import org.neo4j.gis.spatial.filter.SearchRecords;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;

public class LayerRTreeIndex
extends RTreeIndex
implements LayerTreeIndexReader,
Constants {
    private GraphDatabaseService database;
    private Layer layer;

    public LayerRTreeIndex(GraphDatabaseService database, Layer layer) {
        this(database, layer, 100);
    }

    public LayerRTreeIndex(GraphDatabaseService database, Layer layer, int maxNodeReferences) {
        super(database, layer.getLayerNode(), (EnvelopeDecoder)layer.getGeometryEncoder(), maxNodeReferences);
        this.layer = layer;
    }

    @Override
    public Layer getLayer() {
        return this.layer;
    }

    @Override
    public SpatialDatabaseRecord get(Long geomNodeId) {
        Node geomNode = this.database.getNodeById(geomNodeId.longValue());
        this.findLeafContainingGeometryNode(geomNode, true);
        return new SpatialDatabaseRecord(this.layer, geomNode);
    }

    @Override
    public List<SpatialDatabaseRecord> get(Set<Long> geomNodeIds) {
        ArrayList<SpatialDatabaseRecord> results = new ArrayList<SpatialDatabaseRecord>();
        for (Long geomNodeId : geomNodeIds) {
            results.add(this.get(geomNodeId));
        }
        return results;
    }

    @Override
    public SearchRecords search(SearchFilter filter) {
        return new SearchRecords(this.layer, this.searchIndex(filter));
    }
}

