/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.prj.PrjFileReader;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.neo4j.collections.rtree.Listener;
import org.neo4j.collections.rtree.NullListener;
import org.neo4j.gis.spatial.Constants;
import org.neo4j.gis.spatial.EditableLayerImpl;
import org.neo4j.gis.spatial.SpatialDatabaseService;
import org.neo4j.gis.spatial.WKBGeometryEncoder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShapefileImporter
implements Constants {
    private int commitInterval;
    private Listener monitor;
    private GraphDatabaseService database;
    private SpatialDatabaseService spatialDatabase;

    public ShapefileImporter(GraphDatabaseService database, Listener monitor, int commitInterval) {
        if (commitInterval < 1) {
            throw new IllegalArgumentException("commitInterval must be > 0");
        }
        this.commitInterval = commitInterval;
        this.database = database;
        this.spatialDatabase = new SpatialDatabaseService(database);
        if (monitor == null) {
            monitor = new NullListener();
        }
        this.monitor = monitor;
    }

    public ShapefileImporter(GraphDatabaseService database, Listener monitor) {
        this(database, monitor, 1000);
    }

    public ShapefileImporter(GraphDatabaseService database) {
        this(database, null, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String layerName;
        int commitInterval = 1000;
        if (args.length < 2 || args.length > 4) {
            throw new IllegalArgumentException("Parameters: neo4jDirectory shapefile [layerName commitInterval]");
        }
        String neoPath = args[0];
        String shpPath = args[1];
        shpPath = shpPath.substring(0, shpPath.lastIndexOf("."));
        if (args.length == 2) {
            layerName = shpPath.substring(shpPath.lastIndexOf(File.separator) + 1);
        } else if (args.length == 3) {
            layerName = args[2];
        } else {
            layerName = args[2];
            commitInterval = Integer.parseInt(args[3]);
        }
        EmbeddedGraphDatabase database = new EmbeddedGraphDatabase(neoPath);
        try {
            ShapefileImporter importer = new ShapefileImporter((GraphDatabaseService)database, (Listener)new NullListener(), commitInterval);
            importer.importFile(shpPath, layerName);
        }
        finally {
            database.shutdown();
        }
    }

    public void importFile(String dataset, String layerName) throws ShapefileException, FileNotFoundException, IOException {
        this.importFile(dataset, layerName, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFile(String dataset, String layerName, Charset charset) throws ShapefileException, FileNotFoundException, IOException {
        EditableLayerImpl layer = (EditableLayerImpl)this.spatialDatabase.getOrCreateLayer(layerName, WKBGeometryEncoder.class, EditableLayerImpl.class);
        GeometryFactory geomFactory = layer.getGeometryFactory();
        boolean strict = false;
        boolean shpMemoryMapped = true;
        long startTime = System.currentTimeMillis();
        ShpFiles shpFiles = null;
        try {
            shpFiles = new ShpFiles(new File(dataset));
        }
        catch (Exception e) {
            try {
                shpFiles = new ShpFiles(new File(dataset + ".shp"));
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Failed to access the shapefile at either '" + dataset + "' or '" + dataset + ".shp'", e);
            }
        }
        CoordinateReferenceSystem crs = this.readCRS(shpFiles);
        ShapefileReader shpReader = new ShapefileReader(shpFiles, strict, shpMemoryMapped, geomFactory);
        try {
            Class geometryClass = JTSUtilities.findBestGeometryClass((ShapeType)shpReader.getHeader().getShapeType());
            Integer geometryType = SpatialDatabaseService.convertJtsClassToGeometryType(geometryClass);
            DbaseFileReader dbfReader = new DbaseFileReader(shpFiles, shpMemoryMapped, charset);
            try {
                DbaseFileHeader dbaseFileHeader = dbfReader.getHeader();
                String[] fieldsName = new String[dbaseFileHeader.getNumFields() + 1];
                fieldsName[0] = "ID";
                for (int i = 1; i < fieldsName.length; ++i) {
                    fieldsName[i] = dbaseFileHeader.getFieldName(i - 1);
                }
                Transaction tx = this.database.beginTx();
                try {
                    if (crs != null) {
                        layer.setCoordinateReferenceSystem(crs);
                    }
                    if (geometryType != null) {
                        layer.setGeometryType(geometryType);
                    }
                    layer.mergeExtraPropertyNames(fieldsName);
                    tx.success();
                }
                finally {
                    tx.finish();
                }
                this.monitor.begin(dbaseFileHeader.getNumRecords());
                try {
                    ArrayList<Integer> fields = new ArrayList<Integer>();
                    int recordCounter = 0;
                    while (shpReader.hasNext() && dbfReader.hasNext()) {
                        tx = this.database.beginTx();
                        try {
                            int committedSinceLastNotification = 0;
                            for (int i = 0; i < this.commitInterval; ++i) {
                                if (!shpReader.hasNext() || !dbfReader.hasNext()) continue;
                                ShapefileReader.Record record = shpReader.nextRecord();
                                ++recordCounter;
                                ++committedSinceLastNotification;
                                try {
                                    fields.clear();
                                    Geometry geometry = (Geometry)record.shape();
                                    Object[] values = dbfReader.readEntry();
                                    fields.add(recordCounter);
                                    Collections.addAll(fields, values);
                                    if (geometry.isEmpty()) {
                                        this.log("warn | found empty geometry in record " + recordCounter);
                                        continue;
                                    }
                                    layer.add(geometry, fieldsName, fields.toArray(values));
                                    continue;
                                }
                                catch (IllegalArgumentException e) {
                                    this.log("warn | found invalid geometry: index=" + recordCounter, e);
                                }
                            }
                            this.log("info | inserted geometries: " + recordCounter);
                            this.monitor.worked(committedSinceLastNotification);
                            tx.success();
                        }
                        finally {
                            tx.finish();
                        }
                    }
                }
                finally {
                    this.monitor.done();
                }
            }
            finally {
                dbfReader.close();
            }
        }
        finally {
            shpReader.close();
        }
        long stopTime = System.currentTimeMillis();
        this.log("info | elapsed time in seconds: " + 1.0 * (double)(stopTime - startTime) / 1000.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoordinateReferenceSystem readCRS(ShpFiles shpFiles) {
        CoordinateReferenceSystem coordinateReferenceSystem;
        PrjFileReader prjReader = new PrjFileReader(shpFiles);
        try {
            coordinateReferenceSystem = prjReader.getCoodinateSystem();
        }
        catch (Throwable throwable) {
            try {
                prjReader.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        prjReader.close();
        return coordinateReferenceSystem;
    }

    private void log(String message) {
        System.out.println(message);
    }

    private void log(String message, Exception e) {
        System.out.println(message);
        e.printStackTrace();
    }
}

