/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial;

import com.vividsolutions.jts.geom.Geometry;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.gis.spatial.Constants;
import org.neo4j.gis.spatial.Layer;
import org.neo4j.gis.spatial.SpatialDatabaseException;
import org.neo4j.gis.spatial.SpatialDatabaseService;
import org.neo4j.gis.spatial.SpatialRecord;
import org.neo4j.gis.spatial.attributes.PropertyMapper;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SpatialDatabaseRecord
implements Constants,
SpatialRecord {
    private Node geomNode;
    private Geometry geometry;
    private Layer layer;

    public SpatialDatabaseRecord(Layer layer, Node geomNode) {
        this(layer, geomNode, null);
    }

    @Override
    public String getId() {
        return Long.toString(this.geomNode.getId());
    }

    public long getNodeId() {
        return this.geomNode.getId();
    }

    public Node getGeomNode() {
        return this.geomNode;
    }

    public int getType() {
        return SpatialDatabaseService.convertJtsClassToGeometryType(this.getGeometry().getClass());
    }

    @Override
    public Geometry getGeometry() {
        if (this.geometry == null) {
            this.geometry = this.layer.getGeometryEncoder().decodeGeometry((PropertyContainer)this.geomNode);
        }
        return this.geometry;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.layer.getCoordinateReferenceSystem();
    }

    public String getLayerName() {
        return this.layer.getName();
    }

    @Override
    public boolean hasProperty(String name) {
        PropertyMapper mapper = this.layer.getPropertyMappingManager().getPropertyMapper(name);
        return mapper == null ? this.hasGeometryProperty(name) : this.hasGeometryProperty(mapper.from());
    }

    private boolean hasGeometryProperty(String name) {
        return this.layer.getGeometryEncoder().hasAttribute(this.geomNode, name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.layer.getExtraPropertyNames();
    }

    public Object[] getPropertyValues() {
        String[] names = this.getPropertyNames();
        if (names == null) {
            return null;
        }
        Object[] values = new Object[names.length];
        for (int i = 0; i < names.length; ++i) {
            values[i] = this.getProperty(names[i]);
        }
        return values;
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] names = this.getPropertyNames();
        for (int i = 0; i < names.length; ++i) {
            result.put(names[i], this.getProperty(names[i]));
        }
        return result;
    }

    @Override
    public Object getProperty(String name) {
        PropertyMapper mapper = this.layer.getPropertyMappingManager().getPropertyMapper(name);
        return mapper == null ? this.getGeometryProperty(name) : mapper.map(this.getGeometryProperty(mapper.from()));
    }

    private Object getGeometryProperty(String name) {
        return this.layer.getGeometryEncoder().getAttribute(this.geomNode, name);
    }

    public void setProperty(String name, Object value) {
        this.checkIsNotReservedProperty(name);
        this.geomNode.setProperty(name, value);
    }

    public int hashcode() {
        return Long.valueOf(this.geomNode.getId()).hashCode();
    }

    public boolean equals(Object anotherObject) {
        if (!(anotherObject instanceof SpatialDatabaseRecord)) {
            return false;
        }
        SpatialDatabaseRecord anotherRecord = (SpatialDatabaseRecord)anotherObject;
        return this.getNodeId() == anotherRecord.getNodeId();
    }

    public String toString() {
        return "SpatialDatabaseRecord[" + this.getNodeId() + "]: type='" + this.getType() + "', props[" + this.getPropString() + "]";
    }

    protected SpatialDatabaseRecord(Layer layer, Node geomNode, Geometry geometry) {
        this.layer = layer;
        this.geomNode = geomNode;
        this.geometry = geometry;
    }

    private void checkIsNotReservedProperty(String name) {
        for (String property : RESERVED_PROPS) {
            if (!property.equals(name)) continue;
            throw new SpatialDatabaseException("Updating not allowed for Reserved Property: " + name);
        }
    }

    private String getPropString() {
        StringBuffer text = new StringBuffer();
        for (String key : this.geomNode.getPropertyKeys()) {
            if (text.length() > 0) {
                text.append(", ");
            }
            text.append(key).append(": ").append(this.geomNode.getProperty(key).toString());
        }
        return text.toString();
    }
}

