/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.neo4j.collections.rtree.Listener;
import org.neo4j.collections.rtree.RTreeRelationshipTypes;
import org.neo4j.gis.spatial.Constants;
import org.neo4j.gis.spatial.DefaultLayer;
import org.neo4j.gis.spatial.DynamicLayer;
import org.neo4j.gis.spatial.EditableLayer;
import org.neo4j.gis.spatial.EditableLayerImpl;
import org.neo4j.gis.spatial.GeometryEncoder;
import org.neo4j.gis.spatial.Layer;
import org.neo4j.gis.spatial.SimplePointLayer;
import org.neo4j.gis.spatial.SpatialDatabaseException;
import org.neo4j.gis.spatial.SpatialDatabaseRecord;
import org.neo4j.gis.spatial.SpatialRelationshipTypes;
import org.neo4j.gis.spatial.WKBGeometryEncoder;
import org.neo4j.gis.spatial.WKTGeometryEncoder;
import org.neo4j.gis.spatial.encoders.Configurable;
import org.neo4j.gis.spatial.encoders.SimplePointEncoder;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.Traverser;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SpatialDatabaseService
implements Constants {
    private Node spatialRoot;
    private GraphDatabaseService database;

    public SpatialDatabaseService(GraphDatabaseService database) {
        this.database = database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getOrCreateRootFrom(Node ref, RelationshipType relType) {
        Relationship rel = ref.getSingleRelationship(relType, Direction.OUTGOING);
        if (rel == null) {
            Transaction tx = this.database.beginTx();
            try {
                Node node = this.database.createNode();
                node.setProperty("type", (Object)"spatial");
                ref.createRelationshipTo(node, relType);
                tx.success();
                Node node2 = node;
                return node2;
            }
            finally {
                tx.finish();
            }
        }
        return rel.getEndNode();
    }

    protected Node getSpatialRoot() {
        if (this.spatialRoot == null) {
            this.spatialRoot = this.getOrCreateRootFrom(this.database.getReferenceNode(), SpatialRelationshipTypes.SPATIAL);
        }
        return this.spatialRoot;
    }

    public String[] getLayerNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Relationship relationship : this.getSpatialRoot().getRelationships((RelationshipType)SpatialRelationshipTypes.LAYER, Direction.OUTGOING)) {
            Layer layer = DefaultLayer.makeLayerFromNode(this, relationship.getEndNode());
            if (layer instanceof DynamicLayer) {
                names.addAll(((DynamicLayer)layer).getLayerNames());
                continue;
            }
            names.add(layer.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public Layer getLayer(String name) {
        for (Relationship relationship : this.getSpatialRoot().getRelationships((RelationshipType)SpatialRelationshipTypes.LAYER, Direction.OUTGOING)) {
            Node node = relationship.getEndNode();
            if (!name.equals(node.getProperty("layer"))) continue;
            return DefaultLayer.makeLayerFromNode(this, node);
        }
        return this.getDynamicLayer(name);
    }

    public Layer getDynamicLayer(String name) {
        ArrayList<DynamicLayer> dynamicLayers = new ArrayList<DynamicLayer>();
        for (Relationship relationship : this.getSpatialRoot().getRelationships((RelationshipType)SpatialRelationshipTypes.LAYER, Direction.OUTGOING)) {
            Layer layer;
            Node node = relationship.getEndNode();
            if (node.getProperty("layer_class", (Object)"").toString().startsWith("DefaultLayer") || !((layer = DefaultLayer.makeLayerFromNode(this, node)) instanceof DynamicLayer)) continue;
            dynamicLayers.add((DynamicLayer)DefaultLayer.makeLayerFromNode(this, node));
        }
        for (DynamicLayer layer : dynamicLayers) {
            for (String dynLayerName : layer.getLayerNames()) {
                if (!name.equals(dynLayerName)) continue;
                return layer.getLayer(dynLayerName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicLayer asDynamicLayer(Layer layer) {
        if (layer instanceof DynamicLayer) {
            return (DynamicLayer)layer;
        }
        Transaction tx = this.database.beginTx();
        try {
            Node node = layer.getLayerNode();
            node.setProperty("layer_class", (Object)DynamicLayer.class.getCanonicalName());
            tx.success();
            DynamicLayer dynamicLayer = (DynamicLayer)DefaultLayer.makeLayerFromNode(this, node);
            return dynamicLayer;
        }
        finally {
            tx.finish();
        }
    }

    public DefaultLayer getOrCreateDefaultLayer(String name) {
        return (DefaultLayer)this.getOrCreateLayer(name, WKBGeometryEncoder.class, DefaultLayer.class, "");
    }

    public EditableLayer getOrCreateEditableLayer(String name, String format, String propertyNameConfig) {
        Class geClass = WKBGeometryEncoder.class;
        if (format != null && format.toUpperCase().startsWith("WKT")) {
            geClass = WKTGeometryEncoder.class;
        }
        return (EditableLayer)this.getOrCreateLayer(name, geClass, EditableLayerImpl.class, propertyNameConfig);
    }

    public EditableLayer getOrCreateEditableLayer(String name) {
        return this.getOrCreateEditableLayer(name, "WKB", "");
    }

    public EditableLayer getOrCreateEditableLayer(String name, String wktProperty) {
        return this.getOrCreateEditableLayer(name, "WKT", wktProperty);
    }

    public EditableLayer getOrCreatePointLayer(String name, String xProperty, String yProperty) {
        Layer layer = this.getLayer(name);
        if (layer == null) {
            String encoderConfig = null;
            if (xProperty != null && yProperty != null) {
                encoderConfig = xProperty + ":" + yProperty;
            }
            return (EditableLayer)this.createLayer(name, SimplePointEncoder.class, EditableLayerImpl.class, encoderConfig);
        }
        if (layer instanceof EditableLayer) {
            return (EditableLayer)layer;
        }
        throw new SpatialDatabaseException("Existing layer '" + layer + "' is not of the expected type: " + EditableLayer.class);
    }

    public Layer getOrCreateLayer(String name, Class<? extends GeometryEncoder> geometryEncoder, Class<? extends Layer> layerClass, String config) {
        Layer layer = this.getLayer(name);
        if (layer == null) {
            return this.createLayer(name, geometryEncoder, layerClass, config);
        }
        if (layerClass == null || layerClass.isInstance(layer)) {
            return layer;
        }
        throw new SpatialDatabaseException("Existing layer '" + layer + "' is not of the expected type: " + layerClass);
    }

    public Layer getOrCreateLayer(String name, Class<? extends GeometryEncoder> geometryEncoder, Class<? extends Layer> layerClass) {
        return this.getOrCreateLayer(name, geometryEncoder, layerClass, "");
    }

    public Layer findLayerContainingGeometryNode(Node geometryNode) {
        Node node;
        Node root = null;
        Iterator i$ = geometryNode.traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, ReturnableEvaluator.ALL_BUT_START_NODE, (RelationshipType)RTreeRelationshipTypes.RTREE_REFERENCE, Direction.INCOMING, (RelationshipType)RTreeRelationshipTypes.RTREE_CHILD, Direction.INCOMING).iterator();
        while (i$.hasNext()) {
            root = node = (Node)i$.next();
        }
        if (root != null) {
            return this.getLayerFromChild(root, (RelationshipType)RTreeRelationshipTypes.RTREE_ROOT);
        }
        System.out.println("Failed to find layer by following RTree index, will search back geometry list");
        i$ = geometryNode.traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, ReturnableEvaluator.ALL_BUT_START_NODE, (RelationshipType)SpatialRelationshipTypes.NEXT_GEOM, Direction.INCOMING).iterator();
        while (i$.hasNext()) {
            root = node = (Node)i$.next();
        }
        if (root != null) {
            return this.getLayerFromChild(root, SpatialRelationshipTypes.NEXT_GEOM);
        }
        return null;
    }

    private Layer getLayerFromChild(Node child, RelationshipType relType) {
        Node layerNode;
        Relationship indexRel = child.getSingleRelationship(relType, Direction.INCOMING);
        if (indexRel != null && (layerNode = indexRel.getStartNode()).hasProperty("layer")) {
            return DefaultLayer.makeLayerFromNode(this, layerNode);
        }
        return null;
    }

    public boolean containsLayer(String name) {
        return this.getLayer(name) != null;
    }

    public Layer createWKBLayer(String name) {
        return this.createLayer(name, WKBGeometryEncoder.class, EditableLayerImpl.class);
    }

    public SimplePointLayer createSimplePointLayer(String name) {
        return (SimplePointLayer)this.createLayer(name, SimplePointEncoder.class, SimplePointLayer.class, null, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public SimplePointLayer createSimplePointLayer(String name, String xProperty, String yProperty) {
        return (SimplePointLayer)this.createLayer(name, SimplePointEncoder.class, SimplePointLayer.class, xProperty + ":" + yProperty, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public Layer createLayer(String name, Class<? extends GeometryEncoder> geometryEncoderClass, Class<? extends Layer> layerClass) {
        return this.createLayer(name, geometryEncoderClass, layerClass, null);
    }

    public Layer createLayer(String name, Class<? extends GeometryEncoder> geometryEncoderClass, Class<? extends Layer> layerClass, String encoderConfig) {
        return this.createLayer(name, geometryEncoderClass, layerClass, encoderConfig, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer createLayer(String name, Class<? extends GeometryEncoder> geometryEncoderClass, Class<? extends Layer> layerClass, String encoderConfig, CoordinateReferenceSystem crs) {
        Transaction tx = this.database.beginTx();
        try {
            if (this.containsLayer(name)) {
                throw new SpatialDatabaseException("Layer " + name + " already exists");
            }
            Layer layer = DefaultLayer.makeLayerAndNode(this, name, geometryEncoderClass, layerClass);
            this.getSpatialRoot().createRelationshipTo(layer.getLayerNode(), (RelationshipType)SpatialRelationshipTypes.LAYER);
            if (encoderConfig != null) {
                GeometryEncoder encoder = layer.getGeometryEncoder();
                if (encoder instanceof Configurable) {
                    ((Configurable)((Object)encoder)).setConfiguration(encoderConfig);
                    layer.getLayerNode().setProperty("geomencoder_config", (Object)encoderConfig);
                } else {
                    System.out.println("Warning: encoder configuration '" + encoderConfig + "' passed to non-configurable encoder: " + geometryEncoderClass);
                }
            }
            if (crs != null && layer instanceof EditableLayer) {
                ((EditableLayer)layer).setCoordinateReferenceSystem(crs);
            }
            tx.success();
            Layer layer2 = layer;
            return layer2;
        }
        finally {
            tx.finish();
        }
    }

    public void deleteLayer(String name, Listener monitor) {
        Layer layer = this.getLayer(name);
        if (layer == null) {
            throw new SpatialDatabaseException("Layer " + name + " does not exist");
        }
        layer.delete(monitor);
    }

    public GraphDatabaseService getDatabase() {
        return this.database;
    }

    public static int convertGeometryNameToType(String geometryName) {
        if (geometryName == null) {
            return 0;
        }
        try {
            return SpatialDatabaseService.convertJtsClassToGeometryType(Class.forName("com.vividsolutions.jts.geom." + geometryName));
        }
        catch (ClassNotFoundException e) {
            System.err.println("Unrecognized geometry '" + geometryName + "': " + e);
            return 0;
        }
    }

    public static String convertGeometryTypeToName(Integer geometryType) {
        return SpatialDatabaseService.convertGeometryTypeToJtsClass(geometryType).getName().replace("com.vividsolutions.jts.geom.", "");
    }

    public static Class<? extends Geometry> convertGeometryTypeToJtsClass(Integer geometryType) {
        switch (geometryType) {
            case 1: {
                return Point.class;
            }
            case 2: {
                return LineString.class;
            }
            case 3: {
                return Polygon.class;
            }
            case 4: {
                return MultiPoint.class;
            }
            case 5: {
                return MultiLineString.class;
            }
            case 6: {
                return MultiPolygon.class;
            }
        }
        return Geometry.class;
    }

    public static int convertJtsClassToGeometryType(Class<? extends Geometry> jtsClass) {
        if (jtsClass.equals(Point.class)) {
            return 1;
        }
        if (jtsClass.equals(LineString.class)) {
            return 2;
        }
        if (jtsClass.equals(Polygon.class)) {
            return 3;
        }
        if (jtsClass.equals(MultiPoint.class)) {
            return 4;
        }
        if (jtsClass.equals(MultiLineString.class)) {
            return 5;
        }
        if (jtsClass.equals(MultiPolygon.class)) {
            return 6;
        }
        return 0;
    }

    public Layer createResultsLayer(String layerName, List<SpatialDatabaseRecord> results) {
        EditableLayer layer = (EditableLayer)this.createWKBLayer(layerName);
        for (SpatialDatabaseRecord record : results) {
            layer.add(record.getGeometry());
        }
        return layer;
    }
}

