/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import com.vividsolutions.jts.linearref.LinearLocation;
import com.vividsolutions.jts.linearref.LocationIndexedLine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.neo4j.collections.rtree.filter.SearchFilter;
import org.neo4j.gis.spatial.Layer;
import org.neo4j.gis.spatial.SpatialDatabaseRecord;
import org.neo4j.gis.spatial.Utilities;
import org.neo4j.gis.spatial.filter.SearchIntersect;
import org.neo4j.gis.spatial.filter.SearchRecords;

public class SpatialTopologyUtils {
    public static ArrayList<PointResult> findClosestEdges(Point point, Layer layer) {
        return SpatialTopologyUtils.findClosestEdges(point, layer, 0.0);
    }

    public static ArrayList<PointResult> findClosestEdges(Point point, Layer layer, double distance) {
        ReferencedEnvelope env = new ReferencedEnvelope(Utilities.fromNeo4jToJts(layer.getIndex().getBoundingBox()), layer.getCoordinateReferenceSystem());
        if (distance <= 0.0) {
            distance = env.getSpan(0) / 100.0;
        }
        Envelope search = new Envelope(point.getCoordinate());
        search.expandBy(distance);
        GeometryFactory factory = layer.getGeometryFactory();
        return SpatialTopologyUtils.findClosestEdges(point, layer, factory.toGeometry(search));
    }

    public static ArrayList<PointResult> findClosestEdges(Point point, Layer layer, Geometry filter) {
        ArrayList<PointResult> results = new ArrayList<PointResult>();
        SearchRecords records = layer.getIndex().search((SearchFilter)new SearchIntersect(layer, filter));
        while (records.hasNext()) {
            SpatialDatabaseRecord record = (SpatialDatabaseRecord)records.next();
            Geometry geom = record.getGeometry();
            if (!(geom instanceof LineString)) continue;
            LocationIndexedLine line = new LocationIndexedLine(geom);
            LinearLocation here = line.project(point.getCoordinate());
            Coordinate snap = line.extractPoint(here);
            double distance = snap.distance(point.getCoordinate());
            results.add(new PointResult(layer.getGeometryFactory().createPoint(snap), record, distance));
        }
        Collections.sort(results);
        return results;
    }

    public static Point locatePoint(Layer layer, Geometry geometry, double measure) {
        return layer.getGeometryFactory().createPoint(SpatialTopologyUtils.locatePoint(geometry, measure));
    }

    public static Coordinate locatePoint(Geometry geometry, double measure) {
        return new LengthIndexedLine(geometry).extractPoint(measure);
    }

    public static Point locatePoint(Layer layer, Geometry geometry, double measure, double offset) {
        return layer.getGeometryFactory().createPoint(SpatialTopologyUtils.locatePoint(geometry, measure, offset));
    }

    public static Coordinate locatePoint(Geometry geometry, double measure, double offset) {
        return new LengthIndexedLine(geometry).extractPoint(measure, offset);
    }

    public static ReferencedEnvelope adjustBounds(ReferencedEnvelope bounds, double zoomFactor, double[] offsetFactor) {
        if (offsetFactor == null || offsetFactor.length < bounds.getDimension()) {
            offsetFactor = new double[bounds.getDimension()];
        }
        ReferencedEnvelope scaled = new ReferencedEnvelope(bounds);
        if (Math.abs(zoomFactor - 1.0) > 0.01) {
            double[] min = scaled.getLowerCorner().getCoordinate();
            double[] max = scaled.getUpperCorner().getCoordinate();
            int i = 0;
            while (i < scaled.getDimension()) {
                double span = scaled.getSpan(i);
                double delta = (span - span * zoomFactor) / 2.0;
                double shift = span * offsetFactor[i];
                System.out.println("Have offset[" + i + "]: " + shift);
                int n = i;
                min[n] = min[n] + (shift + delta);
                int n2 = i++;
                max[n2] = max[n2] + (shift - delta);
            }
            scaled = new ReferencedEnvelope(min[0], max[0], min[1], max[1], scaled.getCoordinateReferenceSystem());
        }
        return scaled;
    }

    public static Envelope adjustBounds(Envelope bounds, double zoomFactor, double[] offset) {
        if (offset == null || offset.length < 2) {
            offset = new double[]{0.0, 0.0};
        }
        Envelope scaled = new Envelope(bounds);
        if (Math.abs(zoomFactor - 1.0) > 0.01) {
            double[] min = new double[]{scaled.getMinX(), scaled.getMinY()};
            double[] max = new double[]{scaled.getMaxX(), scaled.getMaxY()};
            int i = 0;
            while (i < 2) {
                double shift = offset[i];
                System.out.println("Have offset[" + i + "]: " + shift);
                double span = i == 0 ? scaled.getWidth() : scaled.getHeight();
                double delta = (span - span * zoomFactor) / 2.0;
                int n = i;
                min[n] = min[n] + (shift + delta);
                int n2 = i++;
                max[n2] = max[n2] + (shift - delta);
            }
            scaled = new Envelope(min[0], max[0], min[1], max[1]);
        }
        return scaled;
    }

    public static Envelope createEnvelopeForGeometryDensityEstimate(Layer layer, Coordinate point, int limit) {
        if (limit < 1) {
            return new Envelope(point);
        }
        int count = layer.getIndex().count();
        if (count > limit) {
            return SpatialTopologyUtils.createEnvelopeForGeometryDensityEstimate(layer, point, (double)limit / (double)count);
        }
        return Utilities.fromNeo4jToJts(layer.getIndex().getBoundingBox());
    }

    public static Envelope createEnvelopeForGeometryDensityEstimate(Layer layer, Coordinate point, double fraction) {
        if (fraction < 0.0) {
            return new Envelope(point);
        }
        Envelope bbox = Utilities.fromNeo4jToJts(layer.getIndex().getBoundingBox());
        double width = bbox.getWidth() * fraction;
        double height = bbox.getWidth() * fraction;
        Envelope extent = new Envelope(point);
        extent.expandToInclude(point.x - width / 2.0, point.y - height / 2.0);
        extent.expandToInclude(point.x + width / 2.0, point.y + height / 2.0);
        return extent;
    }

    public static class PointResult
    implements Map.Entry<Point, SpatialDatabaseRecord>,
    Comparable<PointResult> {
        private Point point;
        private SpatialDatabaseRecord record;
        private double distance;

        private PointResult(Point point, SpatialDatabaseRecord record, double distance) {
            this.point = point;
            this.record = record;
            this.distance = distance;
        }

        @Override
        public Point getKey() {
            return this.point;
        }

        @Override
        public SpatialDatabaseRecord getValue() {
            return this.record;
        }

        public double getDistance() {
            return this.distance;
        }

        @Override
        public SpatialDatabaseRecord setValue(SpatialDatabaseRecord value) {
            this.record = value;
            return this.record;
        }

        @Override
        public int compareTo(PointResult other) {
            if (this.distance == other.distance) {
                return 0;
            }
            if (this.distance < other.distance) {
                return -1;
            }
            return 1;
        }

        public String toString() {
            return "Point[" + this.point + "] distance[" + this.distance + "] record[" + this.record + "]";
        }
    }
}

