/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import org.neo4j.gis.spatial.AbstractGeometryEncoder;
import org.neo4j.gis.spatial.SpatialDatabaseException;
import org.neo4j.gis.spatial.encoders.Configurable;
import org.neo4j.graphdb.PropertyContainer;

public class WKBGeometryEncoder
extends AbstractGeometryEncoder
implements Configurable {
    private String wkbProperty = "wkb";

    @Override
    public Geometry decodeGeometry(PropertyContainer container) {
        try {
            WKBReader reader = new WKBReader(this.layer.getGeometryFactory());
            return reader.read((byte[])container.getProperty(this.wkbProperty));
        }
        catch (ParseException e) {
            throw new SpatialDatabaseException(e.getMessage(), e);
        }
    }

    @Override
    protected void encodeGeometryShape(Geometry geometry, PropertyContainer container) {
        WKBWriter writer = new WKBWriter();
        container.setProperty(this.wkbProperty, (Object)writer.write(geometry));
    }

    @Override
    public void setConfiguration(String configuration) {
        if (configuration != null && configuration.trim().length() > 0) {
            this.wkbProperty = configuration;
        }
    }

    @Override
    public String getConfiguration() {
        return this.wkbProperty;
    }
}

