/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import org.neo4j.gis.spatial.AbstractGeometryEncoder;
import org.neo4j.gis.spatial.SpatialDatabaseException;
import org.neo4j.gis.spatial.encoders.Configurable;
import org.neo4j.graphdb.PropertyContainer;

public class WKTGeometryEncoder
extends AbstractGeometryEncoder
implements Configurable {
    private String wktProperty = "wkt";

    @Override
    public Geometry decodeGeometry(PropertyContainer container) {
        try {
            WKTReader reader = new WKTReader(this.layer.getGeometryFactory());
            return reader.read((String)container.getProperty(this.wktProperty));
        }
        catch (ParseException e) {
            throw new SpatialDatabaseException(e.getMessage(), e);
        }
    }

    @Override
    protected void encodeGeometryShape(Geometry geometry, PropertyContainer container) {
        WKTWriter writer = new WKTWriter();
        container.setProperty(this.wktProperty, (Object)writer.write(geometry));
    }

    @Override
    public void setConfiguration(String configuration) {
        if (configuration != null && configuration.trim().length() > 0) {
            this.wktProperty = configuration;
        }
    }

    @Override
    public String getConfiguration() {
        return this.wktProperty;
    }
}

