/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.attributes;

import java.util.HashMap;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;

public abstract class PropertyMapper {
    private String from;
    private String to;
    protected String type;
    private String params;

    public PropertyMapper(String from, String to, String type, String params) {
        this.from = from;
        this.to = to;
        this.type = type;
        this.params = params;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PropertyMapper) {
            PropertyMapper other = (PropertyMapper)obj;
            return this.key().equals(other.key());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Node node) {
        Transaction tx = node.getGraphDatabase().beginTx();
        try {
            node.setProperty("from", (Object)this.from);
            node.setProperty("to", (Object)this.to);
            node.setProperty("type", (Object)this.type);
            node.setProperty("params", (Object)this.params);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public abstract Object map(Object var1);

    public String to() {
        return this.to;
    }

    public String from() {
        return this.from;
    }

    public String key() {
        return new StringBuffer().append(this.from).append("-").append(this.to).append("-").append(this.type).append("-").append(this.params).toString();
    }

    public static PropertyMapper fromNode(Node node) {
        String from = (String)node.getProperty("from", null);
        String to = (String)node.getProperty("to", null);
        String type = (String)node.getProperty("type", null);
        String params = (String)node.getProperty("params", null);
        return PropertyMapper.fromParams(from, to, type, params);
    }

    public static PropertyMapper fromParams(String from, String to, String type, String params) {
        if (type == null) {
            return new IdentityMapper(from, to);
        }
        if (type.equals("DeltaLong")) {
            return new DeltaLongMapper(from, to, type, Long.parseLong(params));
        }
        if (type.equals("Days")) {
            return new DaysPropertyMapper(from, to, type, Long.parseLong(params));
        }
        if (type.equals("Map")) {
            return new MapMapper(from, to, type, params);
        }
        return new IdentityMapper(from, to);
    }

    private static class MapMapper
    extends PropertyMapper {
        private HashMap<String, String> map = new HashMap();

        public MapMapper(String from, String to, String type, String params) {
            super(from, to, type, params);
            for (String param : params.split(",")) {
                String[] fields = param.split(":");
                this.map.put(fields[0], fields[1]);
            }
        }

        @Override
        public Object map(Object value) {
            return value == null ? null : this.map.get(value.toString());
        }
    }

    private static class DaysPropertyMapper
    extends DeltaLongMapper {
        private long msPerDay = 86400000L;

        public DaysPropertyMapper(String from, String to, String type, long referenceTimestamp) {
            super(from, to, type, referenceTimestamp);
        }

        @Override
        public Object map(Object value) {
            return (Long)super.map(value) / this.msPerDay;
        }
    }

    private static class DeltaLongMapper
    extends PropertyMapper {
        protected long reference;

        public DeltaLongMapper(String from, String to, String type, long reference) {
            super(from, to, type, Long.toString(reference));
            this.reference = reference;
        }

        @Override
        public Object map(Object value) {
            return (Long)value - this.reference;
        }
    }

    private static class IdentityMapper
    extends PropertyMapper {
        public IdentityMapper(String from, String to) {
            super(from, to, "Identity", "");
        }

        @Override
        public Object map(Object value) {
            return value;
        }
    }
}

