/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.attributes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.neo4j.gis.spatial.Layer;
import org.neo4j.gis.spatial.SpatialRelationshipTypes;
import org.neo4j.gis.spatial.attributes.PropertyMapper;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;

public class PropertyMappingManager {
    private Layer layer;
    private LinkedHashMap<String, PropertyMapper> propertyMappers;

    public PropertyMappingManager(Layer layer) {
        this.layer = layer;
    }

    public LinkedHashMap<String, PropertyMapper> getPropertyMappers() {
        if (this.propertyMappers == null) {
            this.propertyMappers = new LinkedHashMap();
            for (PropertyMapper mapper : this.loadMappers().values()) {
                this.addPropertyMapper(mapper);
            }
        }
        return this.propertyMappers;
    }

    private Map<Node, PropertyMapper> loadMappers() {
        HashMap<Node, PropertyMapper> mappers = new HashMap<Node, PropertyMapper>();
        for (Relationship rel : this.layer.getLayerNode().getRelationships((RelationshipType)SpatialRelationshipTypes.PROPERTY_MAPPING, Direction.OUTGOING)) {
            Node node = rel.getEndNode();
            mappers.put(node, PropertyMapper.fromNode(node));
        }
        return mappers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        ArrayList<PropertyMapper> toSave = new ArrayList<PropertyMapper>(this.getPropertyMappers().values());
        ArrayList<Node> toDelete = new ArrayList<Node>();
        for (Map.Entry<Node, PropertyMapper> entry : this.loadMappers().entrySet()) {
            if (toSave.remove(entry.getValue())) continue;
            toDelete.add(entry.getKey());
        }
        GraphDatabaseService db = this.layer.getLayerNode().getGraphDatabase();
        Transaction tx = db.beginTx();
        try {
            for (Node node : toDelete) {
                for (Relationship rel : node.getRelationships()) {
                    rel.delete();
                }
                node.delete();
            }
            for (PropertyMapper mapper : toSave) {
                Node node = db.createNode();
                mapper.save(node);
                this.layer.getLayerNode().createRelationshipTo(node, (RelationshipType)SpatialRelationshipTypes.PROPERTY_MAPPING);
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    private void addPropertyMapper(PropertyMapper mapper) {
        this.getPropertyMappers().put(mapper.to(), mapper);
        this.save();
    }

    public PropertyMapper removePropertyMapper(String to) {
        PropertyMapper mapper = (PropertyMapper)this.getPropertyMappers().remove(to);
        if (mapper != null) {
            this.save();
        }
        return mapper;
    }

    public PropertyMapper getPropertyMapper(String to) {
        return this.getPropertyMappers().get(to);
    }

    public void addPropertyMapper(String from, String to, String type, String params) {
        this.addPropertyMapper(PropertyMapper.fromParams(from, to, type, params));
    }
}

