/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.encoders;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import org.neo4j.gis.spatial.AbstractGeometryEncoder;
import org.neo4j.gis.spatial.SpatialDatabaseException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;

public class SimpleGraphEncoder
extends AbstractGeometryEncoder {
    private GeometryFactory geometryFactory;

    private GeometryFactory getGeometryFactory() {
        if (this.geometryFactory == null) {
            this.geometryFactory = new GeometryFactory();
        }
        return this.geometryFactory;
    }

    private Node testIsNode(PropertyContainer container) {
        if (!(container instanceof Node)) {
            throw new SpatialDatabaseException("Cannot decode non-node geometry: " + container);
        }
        return (Node)container;
    }

    @Override
    protected void encodeGeometryShape(Geometry geometry, PropertyContainer container) {
        Node node = this.testIsNode(container);
        node.setProperty("gtype", (Object)2);
        Node prev = null;
        for (Coordinate coord : geometry.getCoordinates()) {
            Node point = node.getGraphDatabase().createNode();
            point.setProperty("x", (Object)coord.x);
            point.setProperty("y", (Object)coord.y);
            point.setProperty("z", (Object)coord.z);
            if (prev == null) {
                node.createRelationshipTo(point, (RelationshipType)SimpleRelationshipTypes.FIRST);
            } else {
                prev.createRelationshipTo(point, (RelationshipType)SimpleRelationshipTypes.NEXT);
            }
            prev = point;
        }
    }

    @Override
    public Geometry decodeGeometry(PropertyContainer container) {
        Node node = this.testIsNode(container);
        CoordinateList coordinates = new CoordinateList();
        for (Node point : node.traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, ReturnableEvaluator.ALL_BUT_START_NODE, (RelationshipType)SimpleRelationshipTypes.FIRST, Direction.OUTGOING, (RelationshipType)SimpleRelationshipTypes.NEXT, Direction.OUTGOING)) {
            coordinates.add(new Coordinate(((Double)point.getProperty("x")).doubleValue(), ((Double)point.getProperty("y")).doubleValue(), ((Double)point.getProperty("z")).doubleValue()), false);
        }
        return this.getGeometryFactory().createLineString(coordinates.toCoordinateArray());
    }

    protected static enum SimpleRelationshipTypes implements RelationshipType
    {
        FIRST,
        NEXT;

    }
}

